<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductGroup extends Model
{
    use HasFactory;
    protected $guarded = [];


    public function productGroupProductAttribute(){
        return $this->belongsToMany(ProductAttributes::class ,"product_group_product_attributes" ,"product_group_id","product_attribute_id");
    }

    public function productAttribute(){
        return $this->belongsToMany(ProductAttributes::class ,"product_group_product_attributes" ,"product_group_id",'product_attribute_id');
    }

    public function attributes_value(){
        return $this->belongsToMany(AttributeValues::class ,"product_attributes" ,"id",'attribute_value_id');
    }

    public function stock(){
        return $this->hasMany(Stock::class ,'product_group_id');
    }

    public function stockAvailable(){
        return $this->hasOne(Stock::class ,'product_group_id');
        // return $this->hasOne(Stock::class ,'product_group_id')->where('quantity' ,'>' , 0);
    }


    public function productStock(){
        return $this->hasOne(Stock::class ,'product_group_id');
    }


    public function groupOptions(){
        return $this->hasMany(ProductAttributes::class ,'product_group_id');
    }

    public function product(){
        return $this->belongsTo(Products::class ,'product_id');
    }
    
}
