<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductAttributes extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function productGroupProductAttribute(){
        return $this->belongsToMany(ProductAttributes::class ,"product_group_product_attributes" ,"product_attribute_id" , "product_group_id");
    }


    public function attributes(){
        return $this->belongsTo(Attributes::class ,"attribute_id");
    }

    public function attribute_value(){
        return $this->belongsTo(AttributeValues::class ,"attribute_value_id");
    }
}
