<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Categories extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'description', 'id_parent', 'image', 'status', 'slug'];
    // protected $fillable = ['name', 'description', 'id_parent', 'image', 'status'];

    public function products()
    {
        return $this->hasMany(Products::class, "id_category", "id");
    }

    public function children()
    {
        return $this->hasMany(Categories::class, 'id_parent');
    }


    public function setNameAttribute($value)
    {
        $this->attributes['name'] = $value;
        $this->attributes['slug'] = Str::slug($value);
    }

    
    public function parentMember()
    {
        return $this->belongsTo(Categories::class, 'id_parent');
    }
}
