<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cart extends Model
{
    use HasFactory;
    
    protected $fillable = ['id_stock', 'quantity', 'id_user'];

    public function stock()
    {
        return $this->belongsTo(Stock::class, "id_stock", "id");
    }

    public function user()
    {
        return $this->belongsTo(User::class, "id_user", "id");
    }
}