<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attributes extends Model
{
    use HasFactory;

    public function attributeValues(){
        return $this->hasMany(AttributeValues::class , 'attribute_id');
    }

    public function products()
    {
        return $this->hasMany(Products::class, "shop_id", "id");
    }

    public function productOption()
    {
        return $this->hasMany(ProductOptions::class, "product_attr_id", "id");
    }
}
