<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Attributes;
use App\Models\AttributeValues;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class UpdateAttributesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [

            'id'   => 'required',
            'name' => 'required',
            //
        ];
    }

    public function update($model)
    {

        $attribute = $model::where(['id' => $this->id, 'user_id' =>  auth()->user()->id])->first();

        $attribute->name    = $this->name;
        $attribute->save();

        // $attributes = explode("|", $this->value);

        // foreach ($attributes as $attributeValue) {

        //     $attribute->attributeValues()->updateOrCreate([
        //         'value' => trim($attributeValue)
        //     ]);
        // }

        $attribute->load('attributeValues');


        return response()->json([

            'success' => true,
            'data' => $attribute,
            'message' => 'Attribute updated successfully',

        ], 200);
    }


    public function updateOption($model)
    {
        
    }
}
