<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\ShippingCharges;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;


class StoreShippingChargesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }


    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json([
            'success' => false,
            'errors'  => $validator->errors(),
            'message' =>  "The given data was invalid."

        ], 422));
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [

            'charges' => 'required|numeric',
            'shop_id' => 'required'
            //
        ];
    }


    public function store()
    {
        $shippingCharges = ShippingCharges::where(['shop_id' => trim($this->shop_id), 'user_id' =>  auth()->user()->id])->first();
        if (empty($shippingCharges)) {
            $shippingCharges = new ShippingCharges;
        }

        $shippingCharges->charges    = $this->charges;
        $shippingCharges->user_id    = auth()->user()->id;
        $shippingCharges->shop_id    = $this->shop_id;
        $shippingCharges->free_shipping    = $this->free_shipping??0;
        $shippingCharges->save();

        return response()->json([

            'success' => true,
            'data' => $shippingCharges,
            'message' => 'Attributes added successfully',

        ], 200);
    }
}
