<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Attributes;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class StoreAttributesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [

            'name' => 'required',
            'value' => 'required'
            //
        ];
    }


    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json([
            'success' => false,
            'errors'  => $validator->errors(),
            'message' =>  "The given data was invalid."

        ], 422));
    }

    public function store()
    {
        $attribute = Attributes::where(['name' => trim($this->name), 'user_id' =>  auth()->user()->id])->first();
        if (empty($attribute)) {
            $attribute = new Attributes;
        }

        $attribute->name    = $this->name;
        $attribute->user_id = auth()->user()->id;
        $attribute->slug    = str_replace(" ","_",trim($this->name));
        $attribute->save();

        $attributes = explode("|" , $this->value);

        foreach ($attributes as $attributeValue) {

            $attribute->attributeValues()->updateOrCreate([
                'value' => trim($attributeValue)
            ]);
        }

        $attribute->load('attributeValues');

        return response()->json([

            'success' => true,
            'data' => $attribute,
            'message' => 'Attributes added successfully',

        ], 200);
    }
}
