<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{Wishlist, Products, Shops};
use Illuminate\Support\Facades\Validator;


class WishListConttroller extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {

            $categoryMenu = Wishlist::where('user_id', auth()->user()->id)->orderBy('id', 'desc')
                ->with('product.gallery_images')
                ->with(['productGroup.productAttribute.attributes'])
                ->with(['productGroup.productAttribute.attribute_value'])

                ->paginate(10);

            return response()->json([

                'success' => true,
                'data' => $categoryMenu,
                'message' => 'Wishlist.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $validator = Validator::make($request->all(), [

            'product_id' => 'required|string|max:255',

        ]);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        try {


            $product = Products::find($request->product_id);
            if (empty($product)) {

                return response()->json([

                    'success' => false,
                    'data' => "Product not available",
                    'message' => 'error reviews.',

                ], 422);
            }

            $queryArr = [
                'user_id'             => auth()->user()->id,
                'product_id'          => $request->product_id
            ];

            if (!empty($request->product_group_id)) {
                $queryArrp['product_group_id'] = $request->product_group_id ? $request->product_group_id : null;
            }

            $wishlist = Wishlist::where($queryArr)->first();

            if (empty($wishlist)) {
                $wishlist = new Wishlist;
            }

            if ($request->product_group_id) {
                $wishlist->product_group_id    = $request->product_group_id;
            }

            $wishlist->user_id    = auth()->user()->id;
            $wishlist->product_id = $request->product_id;
            $wishlist->save();


            return response()->json([

                'success' => true,
                'data' =>  $wishlist,
                'message' => 'Product reviews.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        //

        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        try {

            $wishlist = Wishlist::find($id);
            $wishlist->delete();

            return response()->json([

                'success' => true,
                'data' =>  $wishlist,
                'message' => 'deleted successfully.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }

        //
    }
}
