<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreUserCardsRequest;
use App\Http\Requests\UpdateUserCardsRequest;
use Illuminate\Http\Request;
use App\Models\UserCards;
use Illuminate\Support\Facades\Validator;

// use Stripe;


class UserCardsController extends Controller
{
    public function __construct()
    {
        

        // return [
        //     'success' => false,
        //     'message' =>  env('STRIPE_SECRET'),
        //     'data' => null,
        //     'status_code' => 422
        // ];
    }

    static $currency = 'usd';
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        try {

            $cards = UserCards::where('user_id',auth()->user()->id)->get();
     

            return response()->json([
                'status'  => true,
                'data'    => $cards,
                'message' => 'card  Successfully'
            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([
                'status'  => true,
                'data'    => $e->getMessage(),
                'message' => 'erro'
            ], 200);

        }

        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($request)
    {
        
        // $validator = Validator::make($request->all(), [

        //     'name' => 'required|string|max:25',
        //     'about_shop' => 'required|string|max:255',
        //     'id_shop_niche' => 'required', // Testing Values 1,2,3,4,5,6
        //     'shop_type' => 'required|boolean|in:0,1', // Virtural 1 or Physical 0
        //     'logo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        //     'street_address' => 'required|string|max:255',
        //     'suite_apt' => 'nullable|string',
        //     'city' => 'required|string',
        //     'state' => 'required|string',
        //     'zip' => 'required|string',

        // ]);

        // $data = $request->all();

        // if ($validator->fails()) {

        //     return response()->json([

        //         'success' => false,
        //         'data' => $validator->errors()

        //     ], 422);
        // }


        return [
            'success' => false,
            'message' =>  env('STRIPE_SECRET'),
            'data' => null,
            'status_code' => 422
        ];

        
        try {

            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET'));

            $cc = $stripe->tokens->create([
                'card' => [
                    'number' => 4242424242424242,
                    'exp_month' => 7,
                    'exp_year' => 2023,
                    'cvc' => 314,
                ],
            ]);

            // for save payment methods charge amount
            if ($request->is_save == "yes") {

                $userCard = UserCards::where(['last4digit' => $cc->card->last4, 'brand' => $cc->card->brand, 'user_id' => auth()->user()->id])->first();

                if (empty($userCard)) {
                    $userCard = new UserCards;
                }

                // $userCard->customer_id  = ;
                $userCard->brand        = $cc->card->brand;
                $userCard->last4digit   = $cc->card->last4;
                $userCard->card_details = $cc;
                $userCard->user_id      = auth()->user()->id;
                $userCard->save();


                $userCardCheck = UserCards::where(['last4digit' => $cc->card->last4, 'brand' => $cc->card->brand, 'user_id' => auth()->user()->id])->first();

                $customer = $stripe->customers->create([
                    'card'  => $cc->id,
                    'description' => auth()->user()->firstname . ' ' . auth()->user()->lastname,
                ]);


                if (empty($userCardCheck->customer_id)) {
                    $userCardCheck->customer_id = $customer->id;
                    $userCardCheck->save();
                }

                $chargesAmount = self::chargeAmount(['is_save' => 'yes', 'amount' => 100, 'customer_id' => $userCardCheck->customer_id]);

                return [
                    'success' => true,
                    'message' => 'Payment successfully.',
                    'status_code' => 200
                ];
            }


            $chargesAmount = self::chargeAmount(['is_save' => 'no', 'amount' => 100, 'stipe_token' => $cc->id]);

            return [

                'success' => true,
                'message' => 'loaded successfully.',
                'data' => $chargesAmount,
                'status_code' => 200

            ];

            //code...
        } catch (\Exception $e) {

            return[
                'success' => false,
                'message' => $e->getMessage(),
                'data' => null,
                'status_code' => 422
            ];
        }
    }


    public function chargeAmount($data = [])
    {
        // dd(self::$currency);
        $stripeCharge = new \Stripe\StripeClient(env('STRIPE_SECRET'));

        if ($data['is_save'] == "yes") {

            $charge = $stripeCharge->charges->create([
                'amount'      => $data['amount'] * 100,
                'currency'    => self::$currency,
                'customer'    => $data['customer_id'],
                'description' => 'checkout payment guinee',
            ]);
        } else {

            $charge = $stripeCharge->charges->create([
                'amount'      => $data['amount'] * 100,
                'currency'    => self::$currency,
                'source'      => $data['stipe_token'],
                'description' => 'checkout payment guinee',
            ]);
        }

        return $charge;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreUserCardsRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreUserCardsRequest $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\UserCards  $userCards
     * @return \Illuminate\Http\Response
     */
    public function show(UserCards $userCards)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\UserCards  $userCards
     * @return \Illuminate\Http\Response
     */
    public function edit(UserCards $userCards)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateUserCardsRequest  $request
     * @param  \App\Models\UserCards  $userCards
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateUserCardsRequest $request, UserCards $userCards)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\UserCards  $userCards
     * @return \Illuminate\Http\Response
     */
    public function destroy(UserCards $userCards)
    {
        //
    }


    public function saveUserCard(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'number'    => 'required',
            'exp_month' => 'required|string|max:255',
            'exp_year'  => 'required', 
            'cvc' => 'required'
        ]);

        $data = $request->all();

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }



        try {

            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET'));

            $cc = $stripe->tokens->create([
                'card' => [
                    'number'    => $request->number,
                    'exp_month' => $request->exp_month,
                    'exp_year'  => $request->exp_year,
                    'cvc'       => $request->cvc,
                ],
            ]);

            // for save payment methods charge amount
            // if ($request->is_save == "yes") {

            $userCard = UserCards::where(['last4digit' => $cc->card->last4, 'brand' => $cc->card->brand, 'user_id' => auth()->user()->id])->first();

            if (empty($userCard)) {
                $userCard = new UserCards;
            }

            // $userCard->customer_id  = ;
            $userCard->brand        = $cc->card->brand;
            $userCard->last4digit   = $cc->card->last4;
            $userCard->card_details = $cc;
            $userCard->user_id      = auth()->user()->id;
            $userCard->save();


            $userCardCheck = UserCards::where(['last4digit' => $cc->card->last4, 'brand' => $cc->card->brand, 'user_id' => auth()->user()->id])->first();

            $customer = $stripe->customers->create([
                'card'  => $cc->id,
                'description' => auth()->user()->firstname . ' ' . auth()->user()->lastname,
            ]);


            if (!empty($userCardCheck)) {
                $userCardCheck->customer_id = $customer->id;
                $userCardCheck->save();


                return response()->json([

                    'success' => false,
                    'data' => [],
                    'message' => 'card added.',

                ], 200);
            }
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error'=>$e->getMessage()],
                'message' => 'cart.',

            ], 422);
        } 
    }


    public function deleteserCard(Request $request)
    {


        try {

            $userCard = UserCards::where(['id' => $request->card_id, 'user_id' => auth()->user()->id])->first();

            $userCard->delete();

            return response()->json([

                'success' => true,
                'data' => $userCard,
                'message' => 'card deleted.',

            ], 200);
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => $e->getMessage(),
                'message' => 'card.',

            ], 422);
        }
    }

}
