<?php

namespace App\Http\Controllers;

use App\Models\Categories;
use App\Models\Products;
use App\Models\Shops;
use App\Models\{AttributeValues, ProductGallery, UserLogs};
use Illuminate\Support\Str;
use Exception;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class SiteController extends Controller
{
    public function categoryMenu()
    {
        $categoryMenu = Categories::where('status', 1)->with(['children' => function ($q) {
            return $q->where('status', 1);
        }])->where('id_parent', 0)->orderBy('id', 'desc')->get(['id', 'name', 'id_parent']);

        foreach ($categoryMenu as $key => $value) {
            $value->is_show = false;
            $value->children->map(function ($ql) {
                $ql->is_checked = false;
                return  $ql;
            });
            # code...
        }

        return response()->json([

            'success' => true,
            'data' => $categoryMenu,
            'message' => 'Category Menu.',

        ], 200);
    }


    public function homeMainCats()
    {
        $categoryMenu = Categories::where('status', 1)->where('id_parent', 0)->orderBy('id', 'desc')->take(3)->get();

        return response()->json([

            'success' => true,
            'data' => $categoryMenu,
            'message' => 'Category Menu.',

        ], 200);
    }

    public function  subCategoryMenu(Request $request)
    {
        // dd();
        $query = Categories::where('status', 1)->where("id_parent", "!=", 0)->orderBy('id', 'desc');
        if ($request->cat_id) {
            $query->whereIn('id_parent', $request->cat_id);
        }


        $categoryMenu = $query->get();


        return response()->json([

            'success' => true,
            'data' => $categoryMenu,
            'message' => 'Category Menu.',

        ], 200);
    }


    public function browseShops(Request $request)
    {
        $query = Shops::select("*")->where('status', 1);

        if (!empty($request->title)) {
            $titleSearch = $request->title;
            $query->where('name', 'like', "%$titleSearch%");
        }

        $shops = $query->orderBy('id', 'desc')->paginate(12);

        return response()->json([

            'success' => true,
            'data' => $shops,
            'message' => 'All shops.',

        ], 200);
    }

    public function categoryList(Request $request)
    {
        $query = Categories::select("*")->where('status', 1);


        if (!empty($request->title)) {
            $query->where('name', 'like', "%{$request->title}%");
        }


        $categories  = $query->orderBy('id', 'desc')->paginate(3);

        return response()->json([

            'success' => true,
            'data' => $categories,
            'message' => 'All categories.',

        ], 200);
    }

    public function productList(Request $request)
    {

        $currentData = date("Y-m-d");

        $query = Products::selectRaw(DB::raw("*,CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d') >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_featured_status"))
            ->with(['gallery_images', 'productGroup'])->where('status', 1)
            ->withCount(['productRatings as average_rating' => function ($query) {
                return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
            }])
            ->wherehas('shop', function ($q) {
                return $q->where('status', 1);
            })
            ->wherehas('category', function ($q) {
                return $q->where('status', 1);
            })

            // $query->orderByRaw('FIELD(attr_value_id, '.$request->attr_value_id.') DESC');
            // ->orderBy('id', 'desc');
            ->orderByRaw("CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d')  >= " . date("Y-m-d") . " THEN is_featured END DESC ,id DESC");

        // ->wherehas('shop',function($q){
        //     return $q->where('status',1);
        // })


        if (!empty($request->title)) {
            $query->where('name', 'like', "%{$request->title}%");
        }

        if (!empty($request->shop)) {
            $query->where('shop_id', '=', "{$request->shop}");
        }



        if (!empty($request->category)) {
            // return $request->category;
            $query->whereIn('id_category', $request->category);
        }

        if (!empty($request->min_pirce)) {
            $query->whereHas('productGroup', function ($pq) use ($request) {
                return $pq->whereBetween('sale_price', [$request->min_pirce, $request->max_pirce < 1 ? 12000 :  $request->max_pirce]);
            });
        }

        $products = $query->paginate($request->per_page ? $request->per_page : 12);

        return response()->json([

            'success' => true,
            'data' => $products,
            'message' => 'All products.',

        ], 200);
    }



    public function productListPost(Request $request)
    {

        $currentData = date("Y-m-d");

        // return $request->filters;
        $query = Products::selectRaw(DB::raw("*,CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d') >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_featured_status"))
            ->with(['gallery_images', 'productGroup'])->where('status', 1)
            ->withCount(['productRatings as average_rating' => function ($query) {
                return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
            }])
            ->wherehas('shop', function ($q) {
                return $q->where('status', 1);
            });
        // ->orderBy('id', 'desc');

        if (!empty($request->title)) {
            $query->where('name', 'like', "%{$request->title}%");
        }

        if (!empty($request->shop)) {
            $query->where('shop_id', '=', "{$request->shop}");
        }

        $subCats = [];
        $mainCats = [];

        if ($request->filters) {

            foreach ($request->filters as  $mainCat) {

                if ($mainCat['is_show'] == true) {

                    foreach ($mainCat['children'] as $subcat) {

                        if ($subcat['is_checked'] == true) {
                            $subCats[] = $subcat['id'];
                        }



                        // $isAdmin = !in_array(true, array_column($subcat['Roles'], true));


                    }


                    if (!in_array(true, array_column($mainCat['children'], 'is_checked'))) {

                        $mainCats[] = $mainCat['id'];
                    }
                }
                # code...
            }

            $subCatsId = Categories::whereIn('id_parent', $mainCats)->where('status', 1)->get()->pluck('id')->toArray();

            $allSubID = array_merge($subCatsId, $subCats);

            $query->whereIn('id_category', $allSubID);
        }


        // return $subCats;



        // if (!empty($request->category)) {
        //     // return $request->category;
        //     $query->whereIn('id_category', $request->category);
        // }

        if (!empty($request->min_pirce)) {
            $query->whereHas('productGroup', function ($pq) use ($request) {
                return $pq->whereBetween('sale_price', [$request->min_pirce, $request->max_pirce < 1 ? 12000 :  $request->max_pirce]);
            });
        }

        $query->orderByRaw("CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d')  >= " . date("Y-m-d") . " THEN is_featured END DESC ,id DESC");

        $products = $query->paginate($request->per_page ? $request->per_page : 12);

        return response()->json([

            'success' => true,
            'data' => $products,
            'message' => 'All products.',

        ], 200);
    }





    public function featuredProductList()
    {
        $currentData = date("Y-m-d");

        $products = Products::selectRaw(DB::raw("*,CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d') >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_featured_status"))
            ->with(['gallery_images', 'productGroup'])->where('status', 1)
            ->wherehas('shop', function ($q) {
                return $q->where('status', 1);
            })
            ->withCount(['productRatings as average_rating' => function ($query) {
                return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
            }])
            ->orderByRaw("CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d')  >= " . date("Y-m-d") . " THEN is_featured END DESC ,id DESC")->paginate(4);

        // ->orderBy('id', 'desc')->paginate(4);

        return response()->json([

            'success' => true,
            'data' => $products,
            'message' => 'Feature products.',

        ], 200);
    }


    public function recommendedProductList()
    {
        $currentData = date("Y-m-d");
        $products = Products::selectRaw(DB::raw("*,CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d') >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_featured_status"))
            ->with(['gallery_images', 'productGroup'])->where('status', 1)->orderBy('id', 'desc')
            ->wherehas('shop', function ($q) {
                return $q->where('status', 1);
            })
            ->withCount(['productRatings as average_rating' => function ($query) {
                return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
            }])
            ->paginate(4);

        return response()->json([

            'success' => true,
            'data' => $products,
            'message' => 'Feature products.',

        ], 200);
    }


    public function newCollectionProductList()
    {
        $currentData = date("Y-m-d");
        $products = Products::selectRaw(DB::raw("*,CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d') >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_featured_status"))
            ->with(['gallery_images', 'productGroup'])->where('status', 1)->orderBy('id', 'desc')
            ->wherehas('shop', function ($q) {
                return $q->where('status', 1);
            })
            ->withCount(['productRatings as average_rating' => function ($query) {
                return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
            }])
            ->paginate(4);

        return response()->json([

            'success' => true,
            'data' => $products,
            'message' => 'Feature products.',

        ], 200);
    }

    public function singleProduct($id)
    {

        try {

            $currentData = date("Y-m-d");

            $productList = Products::selectRaw(DB::raw("*,CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d') >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_featured_status"))
                ->with('shop')->with('category')->with('gallery_images')

                ->with(['specifications', 'productGroup.stockAvailable'])
                // ->with(['productGroup.productAttribute.attributes'])
                // ->with(['productGroup.productAttribute.attribute_value'])
                ->with(['attributes' => function ($q) {
                    return $q->groupBy('id');
                }])


                ->withCount(['productRatings as average_rating' => function ($query) {
                    return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
                }])
                ->where('status', 1)
                ->wherehas('shop', function ($q) {
                    return $q->where('status', 1);
                })
                ->wherehas('category', function ($q) {
                    return $q->where('status', 1);
                })
                ->where('id', $id)->first();


            $productList->attributes->map(function ($q) use ($productList) {
                // dd();
                // $q->is_gallary = $q->productOption()->where(['product_attr_id' => $q->id , 'is_gallary' => 1])->get();
                $q->is_gallary = $q->productOption()->where(['product_attr_id' => $q->id, 'is_gallary' => 1, 'product_id' => $productList->id])->groupBy('product_attr_id')->get()->count();
                $q->attribute_values = AttributeValues::whereHas('productOption', function ($qp) use ($productList, $q) {
                    return $qp->where('product_id', $productList->id)->where('attribute_id', $q->id);
                })->get();
                return $q;
            });

            // $dataCollection = collect($productList);


            // $collection = new Collection($dataCollection['attributes']);


            // //   ;>sortBy('name', SORT_REGULAR, true)


            // $dataCollection['attributes'] = $collection->sortByDesc('is_gallary');

            // return $dataCollection;
            // $productList['attributes'] = [];

            return response()->json([

                'success' => true,
                'data' => $productList,
                'message' => 'Single Product.',

            ], 200);

            //code...
        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => null,
                'message' => $e->getMessage()
            ], 500);
        }


        $productList = Products::with('shop')
            ->with('category')
            ->with('gallery_images')
            ->with('specifications')
            ->with('variations')
            ->where('id', $id)
            ->get();

        return response()->json([

            'success' => true,
            'data' => $productList,
            'message' => 'Single Product.',

        ], 200);
    }


    public function singleProductGallery(Request $request)
    {

        try {

            $query = ProductGallery::select("*")->where('id_product', $request->product_id);

            if ($request->attr_value_id) {

                // $query->where('attr_id',$request->attr_id)->where('attr_value_id',$request->attr_value_id);
                // orderByRaw
                // $query->orderBy('attr_value_id','desc');
                $query->orderByRaw('FIELD(attr_value_id, ' . $request->attr_value_id . ') DESC');
            }

            $gallery = $query->get();

            return response()->json([
                'status'  => true,
                'data'    => $gallery,
                'message' => 'Product Search Successfully'
            ], 200);
        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
    }


    public function mainSearch(Request $request)
    {

        try {

            $request->all();
            $currentData = date("Y-m-d");
            $productSearch = Products::selectRaw(DB::raw("*,CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d') >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_featured_status"))
                ->with(['productGroup', 'shop'])->with('category')->with('gallery_images')

                ->where('status', 1)


                ->withCount(['productRatings as average_rating' => function ($query) {
                    return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
                }])

                // ->withCount(['productBoots as featured_status' => function($query) {
                //     return $query->select(DB::raw("CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d') >= ".date("Y-m-d")." THEN 1 else 0 END"));
                // }])


                // ->wherehas('shop',function($q){
                //     return $q->where('status',1);
                // })


                ->whereHas('category', function ($query) use ($request) {
                    return $query->where('status', 1);
                })
                ->wherehas('shop', function ($q) {
                    return $q->where('status', 1);
                })

                ->where(function ($query) use ($request) {
                    $query->where('name', 'LIKE', "%{$request->name}%")
                        ->OrWhereHas('shop', function ($query)  use ($request) {
                            return $query->where('name', 'LIKE', "%{$request->name}%");
                        })

                        ->OrWhereHas('category', function ($query) use ($request) {
                            return $query->where('name', 'LIKE', "%{$request->name}%");
                        });

                    return $query;
                    // $query->where('status',1)
                })
                // ->orWhere('long_description', 'LIKE', "%{$request->long_description}%") 
                // ->OrWhereHas('shop',function ($query)  use ($request){
                //     return $query->where('name' ,'LIKE', "%{$request->name}%");
                // })
                // ->OrWhereHas('category',function ($query) use ($request){
                //     return $query->where('name' ,'LIKE', "%{$request->name}%");
                // })

                // ->where(function ($query) {
                //     $query->where('status',1);
                // })


                // ->orderBy('id','desc')
                ->orderByRaw("CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d')  >= " . date("Y-m-d") . " THEN is_featured END DESC ,id DESC")
                ->paginate($request->per_page ? $request->per_page : 10);

            return response()->json([
                'status'  => true,
                'data'    => $productSearch,
                'message' => 'Product Search Successfully'
            ], 200);
        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
    }


    public function updateSlugs()
    {

        $catgs = Categories::get();

        foreach ($catgs as  $cat) {
            $cat->update(['slug' => Str::slug($cat->name)]);
        }

        return $catgs;
    }

    public function userLogsSave(Request $request)
    {

        try {

            foreach ($request->logs as $keys => $value) {
                $userLogs = UserLogs::where(['user_id' => auth()->user()->id, 'logs' => trim($value['search_text'])])->first();
    
                if(empty($userLogs)){
                    $userLogs = new UserLogs;
                }
    
                $userLogs->user_id	 = auth()->user()->id;
                $userLogs->logs	     = $value['search_text'];
                $userLogs->save();
    
            }

            return response()->json([
                'status'  => true,
                'data'    => 'added',
                'message' => 'Search added Successfully'
            ], 200);
        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }

        
    }
}
