<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use App\Models\Categories;
use App\Models\MetaData;
use App\Models\MetaKey;
use App\Models\ProductGallery;
use App\Models\Products;
use App\Models\Shops;
use App\Models\ShopAddress;
use App\Models\ShopNiche;
use App\Models\Stock;
use App\Models\User;
use App\Models\ProductAttributes;
use App\Models\ProductGroup;
use App\Models\Attributes;
use App\Models\{
    AttributeValues,
    ProductGroupProductAttribute,
    Orders,
    OrderNumbers,
    ProductOptions
};
use Illuminate\Support\Facades\file;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use Exception;

class ShopsController extends Controller
{
    protected $data = array(
        'id'        => 0,
        'name'      => '',
        'options'   => array(),
        'position'  => 0,
        'visible'   => false,
        'variation' => false,
    );


    public function getCategories()
    {
        $categories = Categories::get();
        return response()->json([

            'success' => true,
            'data' => $categories,
            'message' => 'Product categories.',

        ], 200);
    }

    public function getShopNiche()
    {
        $shopniche = ShopNiche::get();
        return response()->json([

            'success' => true,
            'data' => $shopniche,
            'message' => 'Shop niche.',

        ], 200);
    }

    public function getMetaKeys()
    {
        $metakeys = MetaKey::get();
        return response()->json([

            'success' => true,
            'data' => $metakeys,
            'message' => 'Meta Keys.',

        ], 200);
    }

    public function createShop(Request $request)
    {

        // $userRole = User::find(auth()->user()->id);
        // if(!in_array('Vendor',$userRole->roles->pluck('name')->toArray())){

        //     return "Asdasd";

        // }

        // return $userRole;

        $validator = Validator::make($request->all(), [

            'name' => 'required|string|max:25',
            'about_shop' => 'required|string|max:255',
            'id_shop_niche' => 'required', // Testing Values 1,2,3,4,5,6
            'shop_type' => 'required|boolean|in:0,1', // Virtural 1 or Physical 0
            'logo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'street_address' => 'required|string|max:255',
            'suite_apt' => 'nullable|string',
            'city' => 'required|string',
            'state' => 'required|string',
            'zip' => 'required|string',

        ]);

        $data = $request->all();

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        } else {

            $filename = time() . '.' . request()->logo->getClientOriginalExtension();
            $request->logo->move(public_path('uploads'), $filename);


            $shopArr = [

                'name' => $data['name'],
                'about_shop' => $data['about_shop'],
                'id_shop_niche' => $data['id_shop_niche'],
                'shop_type' => $data['shop_type'],
                'logo' => '/uploads/' . $filename,
                // 'cover_photo' => '/uploads/' . $filenameCover,
                // 'status' => 1,
                'status' => 2,
                'user_id' => auth()->user()->id,
                'delivery_time' => $request->delivery_time

            ];

            if ($request->cover_photo) {
                $filenameCover = 'cover'.time() . '.' . request()->cover_photo->getClientOriginalExtension();
                $request->cover_photo->move(public_path('uploads'), $filenameCover);

                $shopArr['cover_photo'] = '/uploads/' . $filenameCover;
            }

            $shop = Shops::create($shopArr);

            $shopAddress = ShopAddress::create([

                'address_type' => 'Main',
                'street_address' => $data['street_address'],
                'suite_apt' => $data['suite_apt'],
                'city' => $data['city'],
                'state' => $data['state'],
                'zip' => $data['zip'],
                'latitude' => 37.0902,
                'longitude' => 95.7129,
                'status' => 1,
                'shop_id' => $shop->id,

            ]);

            $user = User::find(auth()->user()->id);

            $roleToAssign = Role::where('name', 'Vendor')->first();

            if (!in_array('Vendor', $user->roles->pluck('name')->toArray())) {

                $user->assignRole([$roleToAssign->id]);
            }

            // return $userRole;



            if ($user) {
                $user->store_validate = 1;
                $user->save();
            }

            return response()->json([

                'success' => true,
                'message' => 'Shop created successfully.',
                'data' => [
                    'shop' => $shop,
                    'shop_address' => $shopAddress
                ],

            ], 200);
        }
    }


    public function updateShop(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'name' => 'required|string|max:25',
            'about_shop' => 'required|string|max:255',
            'id_shop_niche' => 'required', // Testing Values 1,2,3,4,5,6
            'shop_type' => 'required|boolean|in:0,1', // Virtural 1 or Physical 0
            'street_address' => 'required|string|max:255',
            'suite_apt' => 'nullable|string',
            'city' => 'required|string',
            'state' => 'required|string',
            'zip' => 'required|string',
            'shop_id' => 'required',
            'delivery_time' => 'required',


        ]);

        $data = $request->all();

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        try {

            $shopArr = [

                'name' => $data['name'],
                'about_shop' => $data['about_shop'],
                'id_shop_niche' => $data['id_shop_niche'],
                'shop_type' => $data['shop_type'],
                'delivery_time' => $request->delivery_time
                // 'status' => 0,

            ];

            if ($request->logo) {

                $filename = time() . '.' . request()->logo->getClientOriginalExtension();
                $request->logo->move(public_path('uploads'), $filename);

                $shopArr['logo'] = '/uploads/' . $filename;
            }

            if ($request->cover_photo) {
                $filenameCover = 'cover'.time() . '.' . request()->cover_photo->getClientOriginalExtension();
                $request->cover_photo->move(public_path('uploads'), $filenameCover);
                $shopArr['cover_photo'] = '/uploads/' . $filenameCover;
            }

            $shop = Shops::where([
                "id" => $request->shop_id,
                'user_id' => auth()->user()->id
            ])->first();

            Shops::where([
                "id" => $request->shop_id,
                'user_id' => auth()->user()->id
            ])->update($shopArr);

            // return $shopArr;

            // $shop;
            // dd($shop->id);

            $shop->address()->update([

                'address_type' => 'Main',
                'street_address' => $data['street_address'],
                'suite_apt' => $data['suite_apt'],
                'city' => $data['city'],
                'state' => $data['state'],
                'zip' => $data['zip'],
                'latitude' => 37.0902,
                'longitude' => 95.7129,
                'status' => 1,
                'shop_id' => $shop->id,

            ]);



            $shop = Shops::where([
                "id" => $request->shop_id,
                'user_id' => auth()->user()->id
            ])->with('address')->first();



            return response()->json([

                'success' => true,
                'message' => 'Shop created successfully.',
                'data' =>  $shop,

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => $e->getMessage(),
                'message' => 'card.',

            ], 422);
        }
    }


    public function addProduct(Request $request)
    {


        $shops = Shops::with('user')->where('user_id', auth()->user()->id)->first();
        $shop_id = isset($shops->id) ? $shops->id : 0;


        // return response()->json([

        //     'success' => false,
        //     'data' => $request->file('select_attr_images')['blue'][0]->getClientOriginalExtension()

        // ], 422);


        $productValArra = [

            'name' => 'required|string|max:255',
            // 'unit_price.*' => 'required|numeric',
            'sale_price.*' => 'required|numeric',
            'quantity.*'   => 'required|numeric',
            'attribute.*'  => 'required',
            'product_sku' => 'required|unique:products',
            'sku.*'  => 'required',
            // 'sku.*' => 'unique:product_groups,sku',


            'short_description' => 'required|string',
            'long_description' => 'required|string',
            'id_category' => 'required',
            'status' => 'required|boolean|in:0,1',
            'selected_attr_image' => 'required',
            'gallery_image.*' => 'image|mimes:jpeg,png,jpg,PNG,JPG,JPEG,webp,WEBP|max:2048',
            'category'  => 'required',
            'id_category'  => 'required',


        ];


        if ($request->sku) {

            foreach ($request->sku as $skuKeySt =>  $skuValueSt) {
                if ($request->sale_price[$skuKeySt] <  $request->discount_price[$skuKeySt]) {

                    return response()->json([

                        'success' => false,
                        'data' => ['error' => 'Discount price less then sale price']

                    ], 422);
                }
            }
        }

        // if (!empty($request->discount_price)) {
        //     $productValArra['discount_price.*'] = 'required|numeric|lt:sale_price.*';
        // }



        $validator = Validator::make($request->all(), $productValArra);


        $data = $request->all();


        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }





        $product = Products::create([

            'name' => $data['name'],
            // 'unit_price' => $data['unit_price'],
            // 'sale_price' => $data['sale_price'],
            'short_description' => $data['short_description'],
            'long_description' => $data['long_description'],
            'id_category' => $data['id_category'],
            'status' => $data['status'],
            'shop_id' => $shop_id,
            'product_sku' => $data['product_sku']

        ]);


        if ($request->file('gallery_image')) {

            $files = $request->file('gallery_image');
            $images = array();

            foreach ($files as $file) {

                $name = time() . '.' . $file->extension();
                // $name = $file->getClientOriginalName();
                $file->move('uploads', $name);
                $images[] = $name;
                $gallery = ProductGallery::create([
                    'image' => '/uploads/' . $name,
                    'id_product' => $product->id,
                ]);
            }
        }



        $allAttr = [];

        if (isset($data['sku'])) {


            // foreach ($data['attribute'] as $key => $value) {

            //     // return  $data['attribute'];

            //     return response()->json([

            //         'success' => false,
            //         'data' =>      $value['Color']

            //     ], 422);

            //     # code...
            // }


            // return response()->json([

            //     'success' => false,
            //     'data' =>      ''

            // ], 422);


            foreach ($data['sku'] as $skuKey =>  $skuValue) {

                // $grpupProduct = ProductGroup::create();

                $groupArr = [
                    'sku'            => $skuValue,
                    'sale_price'     => $request->sale_price[$skuKey],
                    'unit_price'     => $request->unit_price[$skuKey],
                    'discount_price' => $request->discount_price[$skuKey],
                    'product_id'     => $product->id
                ];


                if ($request->hasFile('group_image')) {

                    if (isset(request()->group_image[$skuKey])) {

                        $filename = time() . $skuKey . '.' . request()->group_image[$skuKey]->getClientOriginalExtension();
                        $request->group_image[$skuKey]->move(public_path('uploads'), $filename);
                        $groupArr['image'] = '/uploads/' . $filename;
                    }
                }

                $groupProduct = ProductGroup::create($groupArr);

                $stock = Stock::create([
                    'id_product'         => $product->id,
                    'quantity'           => $data['quantity'][$skuKey],
                    'product_group_id'   => $groupProduct->id
                ]);



                if (isset($data['attribute'])) {

                    $attrKeys = array_keys($data['attribute'][$skuKey]);

                    for ($i = 0; $i < count($attrKeys); $i++) {

                        // product options
                        foreach ($data['attribute'] as $keyAttr => $valueAttr) {


                            $attrFirstMl = Attributes::where(['slug' => $attrKeys[$i], 'user_id' => auth()->user()->id])->first();
                            $attrAttributeValueMl = AttributeValues::where('attribute_id', $attrFirstMl->id)->where('value', $valueAttr[$attrKeys[$i]])->first();


                            $productOption = ProductOptions::where(['product_id' => $product->id, 'product_attr_id' => $attrFirstMl->id, 'product_attr_value_id' => $attrAttributeValueMl->id])->first();
                            if (empty($productOption)) {
                                $productOption = new ProductOptions;
                            }

                            $productOption->product_id = $product->id;
                            $productOption->product_attr_id = $attrFirstMl->id;
                            $productOption->product_attr_value_id = $attrAttributeValueMl->id;
                            $productOption->product_attr_name = $attrFirstMl->slug;
                            $productOption->product_attr_value_text = $attrAttributeValueMl->value;
                            $productOption->save();



                            // $allAttr[] = $valueAttr[$attrKeys[$i]];

                            //     return response()->json([

                            //     'success' => false,
                            //     'data' =>  $valueAttr[$attrKeys[$i]]

                            // ], 422);


                            # code...
                        }

                        // return response()->json([

                        //     'success' => false,
                        //     'data' =>   $attrKeys[$i]

                        // ], 422);


                        // echo $data['attribute'][$skuKey][$attrKeys[$i]];

                        $attrFirst = Attributes::where(['slug' => $attrKeys[$i], 'user_id' => auth()->user()->id])->first();
                        $attrAttributeValue = AttributeValues::where('attribute_id', $attrFirst->id)->where('value', $data['attribute'][$skuKey][$attrKeys[$i]])->first();


                        // $productOption = ProductOptions::where(['product_id' => $product->id, 'product_attr_id' => $attrFirst->id, 'product_attr_value_id' => $attrAttributeValue->id])->first();
                        // if (empty($productOption)) {
                        //     $productOption = new ProductOptions;
                        // }

                        // $productOption->product_id = $product->id;
                        // $productOption->product_attr_id = $attrFirst->id;
                        // $productOption->product_attr_value_id = $attrAttributeValue->id;
                        // $productOption->product_attr_name = $attrFirst->slug;
                        // $productOption->product_attr_value_text = $attrAttributeValue->value;
                        // $productOption->save();

                        $productAttributeId = $product->productAttributes()->create([
                            'attribute_value_id' => $attrAttributeValue->id,
                            'attribute_id'       => $attrFirst->id,
                            'product_group_id'   => $groupProduct->id
                        ]);

                        $productAttributeId->productGroupProductAttribute()->attach($groupProduct->id);
                    }
                }


                // variations gallary
                // $productOptions = ProductOptions::where(['product_id' => $product->id, 'product_attr_name' => $request->selected_attr_image])->get();

                // return response()->json([

                //     'success' => false,
                //     'data' =>    $productOptions

                // ], 422);


                // $imagesArr = array();

                // $arrimg = [];

                // foreach ($productOptions as $productOptionsKey => $productOptionsValue) {

                //     // if ($request->hasFile('select_attr_images')) {

                //         // $filesGallery = $request->file('select_attr_images')[$productOptionsValue->product_attr_value_text];
                //         $filesGallery = $request->file('select_attr_images_'.$productOptionsValue->product_attr_value_text);



                //                     //  return response()->json([

                //                     //     'success' => false,
                //                     //     'data' =>   $filesGallery[0]->extension()

                //                     // ], 422);


                //                     // foreach ($request->file('select_attr_images_red') as $gmKey => $fileGallery) {

                //                     //     $nameG = time() . '.' . $fileGallery->extension();

                //                     //     $allAttr[] = $fileGallery->getClientOriginalName();

                //                     //     // $fileGallery->move('uploads', $nameG);
                //                     //     // $fileGallery->move(public_path().'/uploads/', $nameG);  

                //                     //                     //   return response()->json([

                //                     //                     //         'success' => false,
                //                     //                     //         'data' =>     $gmKey 

                //                     //                     //     ], 422);


                //                     // }






                //         // foreach ($filesGallery as $gmKey => $fileGallery) {


                //         //             //  return response()->json([

                //         //             //     'success' => false,
                //         //             //     'data' =>    $gmKey

                //         //             // ], 422);



                //         //     $arrimg[] =  $fileGallery->extension();


                //         //     $nameG = time() . '.' . $fileGallery->extension();
                //         //     // $name = $file->getClientOriginalName();
                //         //     $fileGallery->move('uploads', $nameG);
                //         //     $imagesArr[] = $nameG;
                //         //     $gallery = ProductGallery::create([
                //         //         'image'         => '/uploads/' . $nameG,
                //         //         'id_product'    => $product->id,
                //         //         'attr_id'       => $productOptionsValue->product_attr_id,
                //         //         'attr_value_id' => $productOptionsValue->product_attr_value_id,
                //         //     ]);
                //         // }
                //     // }


                //     $productOptionsValue->update(['is_gallary' => 1]);

                // }


                // return response()->json([

                //     'success' => false,
                //     'data' =>    $arrimg

                // ], 422);






                // specifications

                if (isset($data['specifications'])) {

                    foreach ($data['specifications'][$skuKey] as $speKey => $speValue) {

                        $meta = MetaData::create([

                            'id_meta_key' => $speKey,
                            'meta_value'  => $speValue,
                            'id_product'  => $product->id,
                            'product_group_id'  => $groupProduct->id

                        ]);
                    }
                }
            } // end here for loop


            // variations gallary
            $productOptions = ProductOptions::where(['product_id' => $product->id, 'product_attr_name' => $request->selected_attr_image])->get();

            foreach ($productOptions as $productOptionsKey => $productOptionsValue) {
                // $filesGallery = $request->file('select_attr_images_'.$productOptionsValue->product_attr_value_text);


                // return response()->json([

                //     'success' => true,
                //     // 'data' => $product,$allAttr
                //     'data' => 'select_attr_images_'.$productOptionsValue->product_attr_value_text,
                //     'message' => 'Stock added successfully.',

                // ], 422);


                foreach ($request->file('select_attr_images_' . str_replace(' ', '_', $productOptionsValue->product_attr_value_text)) as $gmKey => $fileGallery) {
                    $nameG = str_replace(' ', '_', $productOptionsValue->product_attr_value_text) . $fileGallery->getClientOriginalName() . time() . $gmKey . '.' . $fileGallery->extension();
                    // $name = $file->getClientOriginalName();
                    $fileGallery->move('uploads', $nameG);

                    $gallery = ProductGallery::create([
                        'image'         => '/uploads/' . $nameG,
                        'id_product'    => $product->id,
                        'attr_id'       => $productOptionsValue->product_attr_id,
                        'attr_value_id' => $productOptionsValue->product_attr_value_id,
                    ]);
                }


                $productOptionsValue->update(['is_gallary' => 1]);
            }

            //     // if ($request->hasFile('select_attr_images')) {

            //         // $filesGallery = $request->file('select_attr_images')[$productOptionsValue->product_attr_value_text];
            //         $filesGallery = $request->file('select_attr_images_'.$productOptionsValue->product_attr_value_text);


            // foreach ($request->file('select_attr_images_blue') as $gmKey => $fileGallery) {

            //     $nameG = 'blue'.time() . '.' . $fileGallery->extension();

            //     echo  $nameG;

            //     $allAttr[] = $fileGallery->getClientOriginalName();


            //     $request->file('select_attr_images_blue')[$gmKey]->move('uploads', $nameG);


            //     // $fileGallery->move('uploads', $nameG);
            //     // $fileGallery->move(public_path().'/uploads/', $nameG);  

            //                     //   return response()->json([

            //                     //         'success' => false,
            //                     //         'data' =>     $gmKey 

            //                     //     ], 422);


            // }

            // foreach ($request->file('select_attr_images_red') as  $fileGalleryd) {

            //     $nameGs = 'red'.$fileGalleryd->getClientOriginalName().time() . '.' . $fileGalleryd->extension();

            //     echo  $nameGs;

            //     $allAttr[] = $fileGalleryd->getClientOriginalName();

            //     $fileGalleryd->move('uploads', $nameGs);
            //     // $fileGallery->move(public_path().'/uploads/', $nameG);  

            //                     //   return response()->json([

            //                     //         'success' => false,
            //                     //         'data' =>     $gmKey 

            //                     //     ], 422);


            // }


        }


        return response()->json([

            'success' => true,
            'data' => $product,
            // 'data' => $allAttr,
            'message' => 'Stock added successfully.',

        ], 200);
    }




    public function editVariantProduct(Request $request)
    {


        $shops = Shops::with('user')->where('user_id', auth()->user()->id)->first();
        $shop_id = isset($shops->id) ? $shops->id : 0;


        // $productValArra = [

        //     'name' => 'required|string|max:255',
        //     'unit_price.*' => 'required|numeric',
        //     'sale_price.*' => 'required|numeric|gt:unit_price.*',
        //     'quantity.*'   => 'required|numeric',
        //     'attribute.*'  => 'required',
        //     // 'sku.*' => 'required|sku|unique:product_groups,sku.*',
        //     'sku.*'  => 'required',
        //     // 'sku.*' => 'unique:product_groups,sku',


        //     'short_description' => 'required|string',
        //     'long_description' => 'required|string',
        //     'id_category' => 'required',
        //     'status' => 'required|boolean|in:0,1',
        //     'selected_attr_image' => 'required',
        //     'gallery_image.*' => 'image|mimes:jpeg,png,jpg,PNG,JPG,JPEG,webp,WEBP|max:2048',
        //     'category'  => 'required',
        //     'id_category'  => 'required',
        //     'product_id' => 'required',


        // ];

        $productValArra = [

            'name' => 'required|string|max:255',
            // 'unit_price.*' => 'required|numeric',
            'sale_price.*' => 'required|numeric',
            'quantity.*'   => 'required|numeric',
            'attribute.*'  => 'required',
            // 'product_sku' => 'required|unique:products',
            'sku.*'  => 'required',
            // 'sku.*' => 'unique:product_groups,sku',


            'short_description' => 'required|string',
            'long_description' => 'required|string',
            'id_category' => 'required',
            'status' => 'required|boolean|in:0,1',
            'selected_attr_image' => 'required',
            'gallery_image.*' => 'image|mimes:jpeg,png,jpg,PNG,JPG,JPEG,webp,WEBP|max:2048',
            'category'  => 'required',
            'id_category'  => 'required',


        ];


        

        // foreach ($request->sku as $skuskey => $sku) {
        //     // 'email' => 'unique:users,email_address,' . $userId,
        //     $productValArra = array_merge($productValArra, ['sku.' . $skuskey => 'required|unique:product_groups,sku,' . $request->sku_id[$skuskey]]);
        // }

        // return response()->json([

        //     'success' => false,
        //     'data' => $productValArra
        // ], 422);


        $validator = Validator::make($request->all(), $productValArra);


        if ($request->sku) {

            foreach ($request->sku as $skuKeySt =>  $skuValueSt) {
                if ($request->sale_price[$skuKeySt] <  $request->discount_price[$skuKeySt]) {

                    return response()->json([

                        'success' => false,
                        'data' => ['error' => 'Discount price less then sale price']

                    ], 422);
                }
            }
        }

   


        // $validator = Validator::make($request->all(), $productValArra);


        // $data = $request->all();


        // if ($validator->fails()) {

        //     return response()->json([

        //         'success' => false,
        //         'data' => $validator->errors()

        //     ], 422);
        // }





        // foreach ($request->sku as $skuskey => $sku) {



        // return response()->json([

        //     'success' => false,
        //     'data' =>  $request->sku_id[$skuskey]

        // ], 422);

        
        //     $productValArra = array_merge($productValArra, ['sku.' . $skuskey => 'required|unique:product_groups,sku,' . $request->sku_id[$skuskey]]);
        // }


        if ($request->sku) {

            foreach ($request->sku as $skuKeySt =>  $skuValueSt) {
                if ($request->sale_price[$skuKeySt] <  $request->discount_price[$skuKeySt]) {

                    return response()->json([

                        'success' => false,
                        'data' => ['error' => 'Discount price less then sale price']

                    ], 422);
                }
            }
        }


        // if (!empty($request->discount_price)) {
        //     $productValArra['discount_price.*'] = 'required|numeric|lt:sale_price.*';
        // }


        $validator = Validator::make($request->all(), $productValArra);


        $data = $request->all();


        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }





        $product = Products::find($request->product_id);

        // ProductOptions::where(['product_id' => $product->id])->delete();

        $product->update([

            'name' => $data['name'],
            'product_sku' => $data['product_sku'],
            // 'unit_price' => $data['unit_price'],
            // 'sale_price' => $data['sale_price'],
            'short_description' => $data['short_description'],
            'long_description' => $data['long_description'],
            'id_category' => $data['id_category'],
            'status' => $data['status'],
            'shop_id' => $shop_id

        ]);


        if ($request->file('gallery_image')) {

            $files = $request->file('gallery_image');
            $images = array();


            ProductGallery::where('id_product', $request->product_id)
            ->whereNull('attr_value_id')
            ->delete();

            foreach ($files as $file) {

                $name = time() . '.' . $file->extension();
                // $name = $file->getClientOriginalName();
                $file->move('uploads', $name);
                $images[] = $name;
                $gallery = ProductGallery::create([
                    'image' => '/uploads/' . $name,
                    'id_product' => $product->id,
                ]);
            }
        }



        $allAttr = [];

        if (isset($data['sku'])) {



            foreach ($data['sku'] as $skuKey =>  $skuValue) {

                // $grpupProduct = ProductGroup::create();

                $groupArr = [
                    'sku'            => $skuValue,
                    'sale_price'     => $request->sale_price[$skuKey],
                    'unit_price'     => $request->unit_price[$skuKey],
                    'discount_price' => $request->discount_price[$skuKey],
                    'product_id'     => $product->id
                ];


                if ($request->hasFile('group_image')) {

                    if (isset(request()->group_image[$skuKey])) {

                        $filename = time() . $skuKey . '.' . request()->group_image[$skuKey]->getClientOriginalExtension();
                        $request->group_image[$skuKey]->move(public_path('uploads'), $filename);
                        $groupArr['image'] = '/uploads/' . $filename;
                    }
                }


                // return response()->json([

                //     'success' => true,
                //     'data' => $request->product_group[$skuKey],
                //     // 'data' => $allAttr,
                //     'message' => 'Stock added successfully.',
        
                // ], 422);


                $groupProduct = ProductGroup::where('id', $request->product_group[$skuKey])->update($groupArr);
                $groupProductFirst = ProductGroup::where('id', $request->product_group[$skuKey])->first();

                $stock = Stock::where('product_group_id', $groupProductFirst->id)->update([
                    'id_product'         => $product->id,
                    'quantity'           => $data['quantity'][$skuKey],
                    'product_group_id'   => $groupProductFirst->id
                ]);



                if (isset($data['attribute'])) {

                    $attrKeys = array_keys($data['attribute'][$skuKey]);

                    for ($i = 0; $i < count($attrKeys); $i++) {

                        // product options
                        foreach ($data['attribute'] as $keyAttr => $valueAttr) {


                            $attrFirstMl = Attributes::where(['slug' => $attrKeys[$i], 'user_id' => auth()->user()->id])->first();
                            $attrAttributeValueMl = AttributeValues::where('attribute_id', $attrFirstMl->id)->where('value', $valueAttr[$attrKeys[$i]])->first();


                            $productOption = ProductOptions::where(['product_id' => $product->id, 'product_attr_id' => $attrFirstMl->id, 'product_attr_value_id' => $attrAttributeValueMl->id])->first();
                            if (empty($productOption)) {
                                $productOption = new ProductOptions;
                            }

                            $productOption->product_id = $product->id;
                            $productOption->product_attr_id = $attrFirstMl->id;
                            $productOption->product_attr_value_id = $attrAttributeValueMl->id;
                            $productOption->product_attr_name = $attrFirstMl->slug;
                            $productOption->product_attr_value_text = $attrAttributeValueMl->value;
                            $productOption->save();
                        }



                        //$attrFirst = Attributes::where(['slug' => $attrKeys[$i], 'user_id' => auth()->user()->id])->first();
                        //$attrAttributeValue = AttributeValues::where('attribute_id', $attrFirst->id)->where('value', $data['attribute'][$skuKey][$attrKeys[$i]])->first();

                        // $productAttributeId = $product->productAttributes()->create([
                        //     'attribute_value_id' => $attrAttributeValue->id,
                        //     'attribute_id'       => $attrFirst->id,
                        //     'product_group_id'   => $groupProduct->id
                        // ]);

                        // $productAttributeId->productGroupProductAttribute()->attach($groupProduct->id);
                    }
                }
            } // end here for loop


            // variations gallary

            
            
            $productOptions = ProductOptions::where(['product_id' => $product->id, 'product_attr_name' => $request->selected_attr_image])->get();


            
            foreach ($productOptions as $productOptionsKey => $productOptionsValue) {

                if ($request->file('select_attr_images_' . str_replace(' ', '_', $productOptionsValue->product_attr_value_text))) {
                    ProductGallery::where([
                        'id_product'    => $product->id,
                        'attr_id'       => $productOptionsValue->product_attr_id,
                        'attr_value_id' => $productOptionsValue->product_attr_value_id,
                    ])->delete();
                }


                if ($request->file('select_attr_images_' . str_replace(' ', '_', $productOptionsValue->product_attr_value_text))) {

                    foreach ($request->file('select_attr_images_' . str_replace(' ', '_', $productOptionsValue->product_attr_value_text)) as $gmKey => $fileGallery) {
                        $nameG = str_replace(' ', '_', $productOptionsValue->product_attr_value_text) . $fileGallery->getClientOriginalName() . time() . $gmKey . '.' . $fileGallery->extension();
                        // $name = $file->getClientOriginalName();
                        $fileGallery->move('uploads', $nameG);

                        $gallery = ProductGallery::create([
                            'image'         => '/uploads/' . $nameG,
                            'id_product'    => $product->id,
                            'attr_id'       => $productOptionsValue->product_attr_id,
                            'attr_value_id' => $productOptionsValue->product_attr_value_id,
                        ]);
                    }


                    $productOptionsValue->update(['is_gallary' => 1]);
                }
            }


        }


        return response()->json([

            'success' => true,
            'data' => $product,
            // 'data' => $allAttr,
            'message' => 'Stock added successfully.',

        ], 200);
    }




    public function simpleAddProduct(Request $request)
    {


        // return response()->json([

        //     'success' => false,
        //     'data' => $request->all()

        // ], 422);



        $shops = Shops::with('user')->where('user_id', auth()->user()->id)->first();
        $shop_id = isset($shops->id) ? $shops->id : 0;


        $validator = Validator::make($request->all(), [

            'name' => 'required|string|max:255',
            // 'unit_price.*' => 'required|numeric',
            'sale_price.*' => 'required|numeric',
            'quantity.*'   => 'required|numeric',
            'attribute.*'  => 'required',
            'product_sku' => 'required',
            'product_sku' => 'unique:products,product_sku',
            'sku.*'  => 'required',
            // 'sku.*' => 'unique:product_groups,sku',

            'short_description' => 'required|string',
            'long_description' => 'required|string',
            'id_category' => 'required',
            'status' => 'required|boolean|in:0,1',
            'gallery_image' => 'required',
            'gallery_image.*' => 'image|mimes:jpeg,png,jpg,PNG,JPG,JPEG,webp,WEBP|max:2048',
            'category'  => 'required',
            'id_category'  => 'required',

        ]);


        $data = $request->all();


        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        if ($request->sku) {

            foreach ($request->sku as $skuKeySt =>  $skuValueSt) {
                if ($request->sale_price[$skuKeySt] <  $request->discount_price[$skuKeySt]) {

                    return response()->json([

                        'success' => false,
                        'data' => ['error' => 'Discount price less then sale price']

                    ], 422);
                }
            }
        }

        $product = Products::create([

            'name' => $data['name'],
            // 'unit_price' => $data['unit_price'],
            // 'sale_price' => $data['sale_price'],
            'short_description' => $data['short_description'],
            'long_description' => $data['long_description'],
            'id_category' => $data['id_category'],
            'status' => $data['status'],
            'shop_id' => $shop_id,
            'product_type' => 'simple'

        ]);


        if ($request->file('gallery_image')) {

            $files = $request->file('gallery_image');
            $images = array();

            foreach ($files as $file) {

                $name = time() . '.' . $file->extension();
                // $name = $file->getClientOriginalName();
                $file->move('uploads', $name);
                $images[] = $name;


                // return $images[0];
                $gallery = ProductGallery::create([
                    'image' => '/uploads/' . $name,
                    'id_product' => $product->id,
                ]);
            }
        }





        if (isset($data['sku'])) {


            foreach ($data['sku'] as $skuKey =>  $skuValue) {

                // $grpupProduct = ProductGroup::create();

                $groupArr = [
                    'sku'        => $skuValue,
                    'sale_price' => $request->sale_price[$skuKey],
                    'unit_price' => $request->unit_price[$skuKey],
                    'discount_price' => $request->discount_price[$skuKey],
                    'product_id' => $product->id
                ];


                // $groupArr['image'] = '/uploads/' . $images[0];


                if ($request->hasFile('group_image')) {

                    if (isset(request()->group_image[$skuKey])) {

                        $filename = time() . $skuKey . '.' . request()->group_image[$skuKey]->getClientOriginalExtension();
                        $request->group_image[$skuKey]->move(public_path('uploads'), $filename);
                        $groupArr['image'] = '/uploads/' . $images[0];
                    }
                }

                $groupProduct = ProductGroup::create($groupArr);

                $stock = Stock::create([
                    'id_product'         => $product->id,
                    'quantity'           => $data['quantity'][$skuKey],
                    'product_group_id'   => $groupProduct->id
                ]);
            }
        }


        return response()->json([

            'success' => true,
            'data' => $product,
            'message' => 'Stock added successfully.',

        ], 200);
    }



    public function editSimpleAddProduct(Request $request)
    {


        $shops = Shops::with('user')->where('user_id', auth()->user()->id)->first();
        $shop_id = isset($shops->id) ? $shops->id : 0;


        $rules  = [

            'product_id' => 'required',
            'name' => 'required|string|max:255',
            // 'unit_price.*' => 'required|numeric',
            'sale_price.*' => 'required|numeric',
            'quantity.*'   => 'required|numeric',
            'attribute.*'  => 'required',
            'sku.*'  => 'required',
            // 'sku.*' => 'unique:product_groups,sku',
            // 'sku.0' => 'sku|unique:product_groups,sku,22',

            // sku|unique:product_groups,sku,'.$sku]


            'short_description' => 'required|string',
            'long_description' => 'required|string',
            'id_category' => 'required',
            // 'status' => 'required|boolean|in:0,1',
            'gallery_image.*' => 'image|mimes:jpeg,png,jpg,PNG,JPG,JPEG,webp,WEBP|max:2048',
            'category'  => 'required',
            'id_category'  => 'required',

        ];


        foreach ($request->sku as $skuskey => $sku) {
            $rules = array_merge($rules, ['sku.' . $skuskey => 'required|unique:product_groups,sku,' . $request->sku_id[$skuskey]]);
        }

        $validator = Validator::make($request->all(), $rules);

        $data = $request->all();


        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        if ($request->sku) {

            foreach ($request->sku as $skuKeySt =>  $skuValueSt) {
                if ($request->sale_price[$skuKeySt] <=  $request->discount_price[$skuKeySt]) {

                    return response()->json([

                        'success' => false,
                        'data' => ['error' => 'Discount price less then sale price']

                    ], 422);
                }
            }
        }
        

        $product = Products::find($request->product_id);


        $product->update([

            'product_sku' => $data['product_sku'],
            'name' => $data['name'],
            // 'unit_price' => $data['unit_price'],
            // 'sale_price' => $data['sale_price'],
            'short_description' => $data['short_description'],
            'long_description' => $data['long_description'],
            'id_category' => $data['id_category'],
            // 'status' => $data['status'],
            'shop_id' => $shop_id,
            'product_type' => 'simple'

        ]);


        if ($request->file('gallery_image')) {

            $files = $request->file('gallery_image');
            $images = array();

            ProductGallery::where('id_product', $request->product_id)->delete();

            foreach ($files as $file) {

                $name = time() . '.' . $file->extension();
                // $name = $file->getClientOriginalName();
                $file->move('uploads', $name);
                $images[] = $name;





                // return $images[0];
                $gallery = ProductGallery::create([
                    'image' => '/uploads/' . $name,
                    'id_product' => $product->id,
                ]);
            }
        }





        if (isset($data['sku'])) {






            foreach ($data['sku'] as $skuKey =>  $skuValue) {

                

                // $grpupProduct = ProductGroup::create();

                $groupArr = [
                    'sku'        => $skuValue,
                    'sale_price' => $request->sale_price[$skuKey],
                    'unit_price' => $request->unit_price[$skuKey],
                    'discount_price' => $request->discount_price[$skuKey],
                    'product_id' => $product->id
                ];




                // $groupArr['image'] = '/uploads/' . $images[0];


                if ($request->hasFile('group_image')) {

                    if (isset(request()->group_image[$skuKey])) {

                        $filename = time() . $skuKey . '.' . request()->group_image[$skuKey]->getClientOriginalExtension();
                        $request->group_image[$skuKey]->move(public_path('uploads'), $filename);
                        $groupArr['image'] = '/uploads/' . $images[0];
                    }
                }

                $groupProduct = ProductGroup::where('product_id', $product->id)->update($groupArr);

                // return response()->json([

                //     'success' => true,
                //     'data' => $product,
                //     'message' => 'product updated successfully.',

                // ], 422);


                $groupProductDetail = ProductGroup::where('product_id', $product->id)->first();

                $stock = Stock::where([
                    'id_product'         => $product->id,
                    'product_group_id'   => $groupProductDetail->id
                ])->update([
                    'id_product'         => $product->id,
                    'quantity'           => $data['quantity'][$skuKey],
                    'product_group_id'   => $groupProductDetail->id
                ]);
            }
        }


        return response()->json([

            'success' => true,
            'data' => $product,
            'message' => 'product updated successfully.',

        ], 200);
    }



    public function productList()
    {
        $user_id = auth()->user()->id;
        $productList = Products::with(['productGroup', 'shop'])->with('category')->with('gallery_images')->with('specifications')
            ->whereHas('shop', function ($query) use ($user_id) {
                $query->where('user_id', $user_id);
            })
            ->withCount(['productRatings as average_rating' => function ($query) {
                return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
            }])
            ->get();
        return response()->json([

            'success' => true,
            'data' => $productList,
            'message' => 'Product List.',

        ], 200);
    }

    public function productListVendorBoosting()
    {
        $user_id = auth()->user()->id;
        $currentData = date("Y-m-d");
        $productList = Products::selectRaw(DB::raw("*,CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d') >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_featured_status"))
        ->with(['productGroup', 'shop'])->with('category')->with('gallery_images')->with('specifications')
            ->whereHas('shop', function ($query) use ($user_id) {
                $query->where('user_id', $user_id);
            })
            ->withCount(['productRatings as average_rating' => function ($query) {
                return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
            }])
            ->having('is_featured_status','=',0)
            ->get();
            
        return response()->json([

            'success' => true,
            'data' => $productList,
            'message' => 'Product List.',

        ], 200);
    }


    public function productDelete($id)
    {
        $user_id = auth()->user()->id;
        $productList = Products::where('id', $id)
            ->with('shop')
            ->with('category')
            ->with('gallery_images')
            ->with('specifications')
            ->whereHas('shop', function ($query) use ($user_id) {
                $query->where('user_id', $user_id);
            })
            ->first();

        $groupIDs =  $productList->productGroup()->pluck('id');

        if (count($groupIDs)) {
            ProductGroupProductAttribute::whereIn("product_group_id", $groupIDs)->delete();
        }

        $productList->gallery_images()->delete();
        $productList->productAttributes()->delete();
        $productList->productAttributes()->delete();
        $productList->productGroup()->delete();
        $productList->wishLists()->delete();
        $productList->delete();



        return response()->json([

            'success' => true,
            'data' => $productList,
            'message' => 'Product deleted successfully.',

        ], 200);
    }


    public function singleProductList(Request $request)
    {
        $user_id = auth()->user()->id;
        // dd($user_id);
        $productList = Products::with('shop')->with('category')->with('gallery_images')

            ->with('specifications')
            ->with(['productGroup.productAttribute.attributes'])
            ->with(['productGroup.productAttribute.attribute_value'])
            ->with(['attributes'
            // ,'productOptionsName'=> function($po){
            //     return $po->groupBy('product_attr_name');
            // }
            ])
            ->withCount(['productRatings as average_rating' => function ($query) {
                return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
            }])

            ->whereHas('shop', function ($query) use ($user_id) {
                $query->where('user_id', $user_id);
            })
            ->where('id', $request->id)->first();

            $productList->product_options_name = [];
            $productList->product_options_name = $productList->productOptionsName()->groupBy('product_attr_name')->get();
            $productList->gallery_attr = ProductGallery::where('id_product', $request->id)->get()->groupby('attr_value_id');

            // return $productList->productOptionsName()->groupBy('product_attr_name')->get();

            foreach ($productList->product_options_name as $key => $value) {

                $value->attribute_data = Attributes::where('id',$value['product_attr_id'])->first();

                $value->all_values  = ProductOptions::where('product_attr_id',$value['product_attr_id'])->where('product_id', $request->id)->get();
                # code...
            }
            // $productList->load(['productOptionsName'=> function($po){
            //     return $po->groupBy('product_attr_name');
            // }]);


            



        $productList->productGroup->map(function ($q) {
            $q->qty = $q->stock()->sum('quantity');
            // $q->product_options_name = $q->productOptionsName()->sum('quantity');

            
            return $q;
        });

        return response()->json([

            'success' => true,
            'data' => $productList,
            'message' => 'Single Product.',

        ], 200);
    }



    public function getProductStocks(Request $request, $id)
    {
        try {

            $user_id = auth()->user()->id;

            $productList = Products::with('shop')->with('category')
                ->with('gallery_images')
                ->whereHas('shop', function ($query) use ($user_id) {
                    $query->where('user_id', $user_id);
                })
                ->where('id', $id)->first();

            $data = ProductGroup::where('product_id', $productList->id)->with('productStock')->get();



            return response()->json([

                'success' => true,
                'data' => $data,
                'message' => 'Product variations',

            ], 200);
            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
    }


    public function updateStocks(Request $request, $stock_id)
    {
        try {

            $user_id = auth()->user()->id;

            $productList = Products::with('shop')->with('category')
                ->with('gallery_images')
                ->whereHas('shop', function ($query) use ($user_id) {
                    $query->where('user_id', $user_id);
                })
                ->where('id', $request->product_id)->first();

            $stock = Stock::where(['id_product' => $productList->id, 'id' => $stock_id])->first();
            $stock->update(['quantity' => $request->quantity]);

            return response()->json([

                'success' => true,
                'data' => $stock,
                'message' => 'Product stock updated',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
    }


    public function addStock(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'sku'        => 'string|max:255',
            'id_product' => 'required',
            'quantity'   => 'required|numeric',
            'attribute.*'  => 'required',
            'attribute_value.*'  => 'required',
            // 'size' => 'string',
            // 'color_name' => 'string',
            // 'color_image' => 'image|mimes:jpeg,png,jpg,PNG,JPG,JPEG|max:2048',

        ]);

        $data = $request->all();

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }


        // ProductGroup::create([

        //     'sku'           => ,	
        //     'sale_price'    => ,	
        //     'unit_price'    => ,	
        //     'product_id'    => ,

        // ]);

        // foreach($data['attribute'] as $aKey => $aValue){

        //     ProductAttributes::create([
        //         'attribute_id' => $aValue,	
        //         'product_id'   => $data['id_product'],
        //         'value'        => $data['attribute_value'][$aKey],	
        //     ]);

        //     echo $aValue.'ss-'.$aKey."- v".$data['attribute_value'][$aKey]."<br>";
        // }



        // dd($data);


        // ProductAttributes


        // else {

        //     if ($request->hasFile('color_image')){

        //         $filename = time().'.'.request()->color_image->getClientOriginalExtension();
        //         $request->color_image->move(public_path('uploads'), $filename);

        //         $stock = Stock::create([

        //             'sku' => $data['sku'] ?? 'N/A',
        //             'id_product' => $data['id_product'],
        //             'quantity' => $data['quantity'],
        //             'size' => $data['size'] ?? null,
        //             'color_name' => $data['color_name'],
        //             'color_image' => '/uploads/'.$filename,

        //         ]);

        //         return response()->json([

        //             'success' => true,
        //             'data' => $stock,
        //             'message' => 'Stock added successfully.',

        //         ],200);

        //     }
        //     else
        //     {
        //         $stock = Stock::create([

        //             'sku' => $data['sku'] ?? 'N/A',
        //             'id_product' => $data['id_product'],
        //             'quantity' => $data['quantity'],
        //             'size' => $data['size'] ?? null,
        //             'color_name' => $data['color_name'] ?? null,

        //         ]);

        //         return response()->json([

        //             'success' => true,
        //             'data' => $stock,
        //             'message' => 'Stock added successfully.',

        //         ],200);
        //     }
        // }
    }

    public function stockList()
    {
        $user_id = auth()->user()->id;
        $stockList = Stock::with('product.shop')->whereHas('product.shop', function ($query) use ($user_id) {
            $query->where('user_id', $user_id);
        })->get();

        return response()->json([

            'success' => true,
            'data' => $stockList,
            'message' => 'Stock List.',

        ], 200);
    }

    public function singleStockList(Request $request)
    {
        try {

            $user_id = auth()->user()->id;
            $stockList = Stock::with('product.shop')->whereHas('product.shop', function ($query) use ($user_id) {
                $query->where('user_id', $user_id);
            })->where('id', $request->id)->get();

            return response()->json([

                'success' => true,
                'data' => $stockList,
                'message' => 'Single Stock.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function updateStock(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [

            'sku' => 'string|max:255',
            'id_product' => 'required',
            'quantity' => 'required|numeric',
            'size' => 'string',
            'color_name' => 'required|string',
            'color_image' => 'required|image|mimes:jpeg,png,jpg,PNG,JPG,JPEG|max:2048',

        ]);

        $data = $request->all();

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        } else {

            $stock = Stock::find($id);

            if ($request->hasFile('color_image')) {

                if (File::exists(public_path($stock->color_image))) {

                    File::delete(public_path($stock->color_image));
                }

                $filename = time() . '.' . request()->color_image->getClientOriginalExtension();
                $request->color_image->move(public_path('uploads'), $filename);

                $stock->sku = $request->sku;
                $stock->id_product = $request->id_product;
                $stock->quantity = $request->quantity;
                $stock->size = $request->size;
                $stock->color_name = $request->color_name;
                $stock->color_image = '/uploads/' . $filename;

                $stock->update();

                return response()->json([

                    'success' => true,
                    'message' => 'Stock updated successfully.',
                    'data' => $stock,

                ], 200);
            } else {
                $stock->sku = $request->sku;
                $stock->id_product = $request->id_product;
                $stock->quantity = $request->quantity;
                $stock->size = $request->size;
                $stock->color_name = $request->color_name;
                $stock->update();

                return response()->json([

                    'success' => true,
                    'message' => 'Stock updated successfully.',
                    'data' => $stock,

                ], 200);
            }
        }
    }


    public function genGroup(Request $request)
    {

        $validationArray = [];

        // $validator = Validator::make($request->all(), [

        //     'attr.*' => 'required',
        //     'id_product' => 'required',
        //     'quantity' => 'required|numeric',
        //     'size' => 'string',
        //     'color_name' => 'required|string',
        //     'color_image' => 'required|image|mimes:jpeg,png,jpg,PNG,JPG,JPEG|max:2048',

        // ]);

        // $data = $request->all();

        if (empty(array_keys($request->all()))) {

            return response()->json([

                'success' => false,
                'data' => ['error' => ['please select Attribute']]

            ], 422);
        }

        // return response()->json([

        //     'success' => false,
        //     'data' => array_keys($request->all())

        // ], 422);

        // if ($validator->fails()) {

        //     return response()->json([

        //         'success' => false,
        //         'data' => $validator->errors()

        //     ], 422);
        // }


        try {

            $allVariKeys = array_keys($request->all());
            $inputVar = $request->all();
            $array = [];

            for ($i = 0; $i < count($allVariKeys); $i++) {
                $array[$allVariKeys[$i]] = $inputVar[$allVariKeys[$i]];
            }





            foreach ($array as $arraykey => $arrayvalue) {

                $validationArray[$arraykey . ".*"] = 'required';
            }


            $validator = Validator::make($request->all(),   $validationArray);

            if ($validator->fails()) {

                return response()->json([

                    'success' => false,
                    'data' => $validator->errors()

                ], 422);
            }

            // return  $array;

            $attr = $this->generateProductAttr($array);


            return response()->json([

                'success' => true,
                'data' => ['attr' => $attr, 'group_attr_selected' => $array],
                'message' => 'loaded.',

            ], 200);


            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => $e->getMessage(),
                'message' => 'cart.',

            ], 422);
        }
    }

    public function generateProductAttr($array)
    {
        // $array = [
        //     'size'  => ['large'],
        //     'color' => ['gray', 'green' , "red"],
        //     'weight' => ['ff', 'gram'],

        // ];


        function variations($array)
        {
            if (empty($array)) {
                return [];
            }

            function traverse($array, $parent_ind)
            {
                $r = [];
                $pr = '';

                if (!is_numeric($parent_ind)) {
                    $pr = $parent_ind . '-';
                }

                foreach ($array as $ind => $el) {
                    if (is_array($el)) {
                        $r = array_merge($r, traverse($el, $pr . (is_numeric($ind) ? '' : $ind)));
                    } elseif (is_numeric($ind)) {
                        $r[] = $pr . $el;
                    } else {
                        $r[] = $pr . $ind . '-' . $el;
                    }
                }

                return $r;
            }

            //1. Go through entire array and transform elements that are arrays into elements, collect keys
            $keys = [];
            $size = 1;

            foreach ($array as $key => $elems) {
                if (is_array($elems)) {
                    $rr = [];

                    foreach ($elems as $ind => $elem) {
                        if (is_array($elem)) {
                            $rr = array_merge($rr, traverse($elem, $ind));
                        } else {
                            $rr[] = $elem;
                        }
                    }

                    $array[$key] = $rr;
                    $size *= count($rr);
                }

                $keys[] = $key;
            }

            //2. Go through all new elems and make variations
            $rez = [];
            for ($i = 0; $i < $size; $i++) {
                $rez[$i] = [];

                foreach ($array as $key => $value) {
                    $current = current($array[$key]);
                    $rez[$i][$key] = $current;
                }

                foreach ($keys as $key) {
                    if (!next($array[$key])) {
                        reset($array[$key]);
                    } else {
                        break;
                    }
                }
            }

            return  $rez;
        }

        $attrData = collect(variations($array))->sortBy(array_keys($array));
        return $attrData;
    }


    public function newShop()
    {
        try {

            $data = Shops::where('status', 1)->latest()->take(4)
                ->withCount(['shopRatings as average_rating' => function ($query) {
                    return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
                }])
                ->get();

            return response()->json([

                'success' => true,
                'data' => $data,
                'message' => 'loaded.',

            ], 200);


            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
    }


    public function recommendedShop()
    {
        try {

            $query = OrderNumbers::select("*");

            if (isset(auth()->user()->id)) {
                $query->where('vendor_id', isset(Auth::user()->id) ? auth()->user()->id : null);
            }

            $dataShop = $query->groupBy('shop_id')->take(5)->get();


            $shopQuery = Shops::select("*")->where('status', 1)
                ->withCount(['shopRatings as average_rating' => function ($query) {
                    return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
                }]);
            // ->with('shopRatings');
            // return $dataShop->pluck('shop_id')->toArray();

            if (count($dataShop->pluck('shop_id')->toArray()) > 0) {
                $dataShop->pluck('shop_id')->toArray();

                $shopQuery->whereIn('id', $dataShop->pluck('shop_id')->toArray());
            }

            $data = $shopQuery->get();

            return response()->json([

                'success' => true,
                'data' => $data,
                'message' => 'loaded.',

            ], 200);


            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
    }


    public function topShopTrending()
    {
        try {

            $shopQuery = Shops::withCount(['shopRatings as average_rating' => function ($query) {
                return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
            }])
                ->with('address')
                ->having('average_rating', '>', 3)
                ->take(8)
                ->get();


            return response()->json([

                'success' => true,
                'data' => $shopQuery,
                'message' => 'loaded',

            ], 200);
            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
    }


    public function shopDetails(Request $request)
    {
        try {

            $data = Shops::where(['status' => 1, 'id' => $request->shop_id])->with('shipping')
                // ->with(['products' => function ($q) {
                //     return $q->where('status', 1);
                // }])
                ->first();

            return response()->json([

                'success' => true,
                'data' => $data,
                'message' => 'loaded.',

            ], 200);


            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
    }


    public function ProductGalleryDelete(Request $request)
    {

        try {

            // $query = ProductGallery::select("*")->where('id_product',$request->product_id);

            // if($request->attr_value_id){

            //     $query->where('attr_id',$request->attr_id)->where('attr_value_id',$request->attr_value_id);

            // }

            // $gallery = $query->get();

            // return response()->json([
            //     'status'  => true,
            //     'data'    => $gallery,
            //     'message' => 'Product Search Successfully'
            // ], 200);

        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
    }

    public function countNewOrders(){

        try {

            $data = OrderNumbers::where('is_seen',false)->where('vendor_id',auth()->user()->id)->count();
            // $data = OrderNumbers::count();

            return response()->json([
                'status'  => true,
                'data'    => ['count'=>$data],
                'message' => 'Product Search Successfully'
            ], 200);


        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }

    }




    public function vendorDashboardDataCount()
    {

        try {

            $newOrders = OrderNumbers::where('vendor_id',auth()->user()->id)
            // ->where('is_seen',0)
            ->where(function($q){
                return $q->where('order_status','pending')->orWhere('order_status','Pending');
            })
            ->count();


            $totalOrders = OrderNumbers::where('vendor_id',auth()->user()->id)
            ->count();


            $activeOrders = OrderNumbers::where('vendor_id',auth()->user()->id)
            ->where(function($q){
                return $q->where('order_status','Accept')->orWhere('order_status','accept');
            })
            ->count();

            $completeOrders = OrderNumbers::where('vendor_id',auth()->user()->id)
            ->where(function($q){
                return $q->where('order_status','Complete')->orWhere('order_status','complete');
            })
            ->count();


            $shop = Shops::where('user_id',isset(auth()->user()->id) ? auth()->user()->id : null)->first();


            $totalProducts = Products::where('shop_id',$shop->id)
            ->where('status',1)
            ->count();

            $ordersTotalShipping = OrderNumbers::where('vendor_id', auth()->user()->id)->sum('shpping_charges');
            $ordersIds = OrderNumbers::where('vendor_id', auth()->user()->id)->pluck('id')->toArray();
            $ordersTotalsubTotal = Orders::whereIn('id_ordernumber', $ordersIds)->sum('sub_total');
            $ordersTotalDiscountTotal = Orders::whereIn('id_ordernumber', $ordersIds)->sum('discount_sub_total');
          
            
        
            
            return response()->json([
                'status'  => true,
                'data'    => [
                    'active_orders_count'  => $completeOrders,
                    'new_orders_count'     => $newOrders,
                    'active_orders_count'  => $activeOrders,
                    'total_product_count'  => $totalProducts,
                    'total_earnings_count' => ($ordersTotalsubTotal +$ordersTotalDiscountTotal) + $ordersTotalShipping ,
                    'total_category_count' => Categories::where('status',1)->count("id"),
                    'total_orders_count'   => $totalOrders
                    
                ],
                'message' => 'Product Search Successfully'
            ], 200);


        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
    }






    public function customerDashboardDataCount()
    {

        try {

            $newOrders = OrderNumbers::where('is_seen',false)
            ->where('vendor_id',auth()->user()->id)
            ->where(function($q){
                return $q->where('order_status','pending')->orWhere('order_status','Pending');
            })
            ->count();


            $totalOrders = OrderNumbers::where('vendor_id',auth()->user()->id)
            ->count();


            $activeOrders = OrderNumbers::where('vendor_id',auth()->user()->id)
            ->where(function($q){
                return $q->where('order_status','Accept')->orWhere('order_status','accept');
            })
            ->count();

            $completeOrders = OrderNumbers::where('vendor_id',auth()->user()->id)
            ->where(function($q){
                return $q->where('order_status','Complete')->orWhere('order_status','complete');
            })
            ->count();


            $shop = Shops::where('user_id',isset(auth()->user()->id) ? auth()->user()->id : null)->first();


            $totalProducts = Products::where('shop_id',$shop->id)
            ->where('status',1)
            ->count();
            
        
            
            return response()->json([
                'status'  => true,
                'data'    => [
                    'active_orders_count'  => $completeOrders,
                    'new_orders_count'     => $newOrders,
                    'active_orders_count'  => $activeOrders,
                    'total_product_count'  => $totalProducts,
                    'total_earnings_count' => 150,
                    'total_category_count' => Categories::where('status',1)->count("id"),
                    'total_orders_count'   => $totalOrders
                    
                ],
                'message' => 'Product Search Successfully'
            ], 200);


        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
    }


    public function updateNewOrdersStatus(){

        try {

            $data = OrderNumbers::where('vendor_id',auth()->user()->id)->update([
                'is_seen' => 1
            ]);
            // $data = OrderNumbers::count();

            return response()->json([
                'status'  => true,
                'data'    => $data,
                'message' => 'Product Search Successfully'
            ], 200);


        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }

    }

    
}
