<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreShippingChargesRequest;
use App\Http\Requests\UpdateShippingChargesRequest;
use App\Models\ShippingCharges;
use Illuminate\Http\Request;

class ShippingChargesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreShippingChargesRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreShippingChargesRequest $request)
    {
        try {

            return  $request->store();
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }


    public function view(Request $request)
    {
        try {

            $shippingCharges = ShippingCharges::where(['shop_id' => $request->shop_id, 'user_id' =>  auth()->user()->id])->first();
            return response()->json([
                'success' => true,
                'data' => $shippingCharges,
                'message' => 'successfully',
            ], 200);
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ShippingCharges  $shippingCharges
     * @return \Illuminate\Http\Response
     */
    public function show(ShippingCharges $shippingCharges)
    {
        
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ShippingCharges  $shippingCharges
     * @return \Illuminate\Http\Response
     */
    public function edit(ShippingCharges $shippingCharges)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateShippingChargesRequest  $request
     * @param  \App\Models\ShippingCharges  $shippingCharges
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateShippingChargesRequest $request, ShippingCharges $shippingCharges)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ShippingCharges  $shippingCharges
     * @return \Illuminate\Http\Response
     */
    public function destroy(ShippingCharges $shippingCharges)
    {
        //
    }
}
