<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use App\Models\{ProductRatings , Products};

class Rating extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {

            $data = ProductRatings::get();

            return response()->json([

                'success' => true,
                'data' => $data,
                'message' => 'Product categories.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }

    public function productRatingById($id)
    {
        try {

            $data = ProductRatings::where('id_product',$id)
            ->with('user')
            ->get();
            return response()->json([

                'success' => true,
                'data' => $data,
                'message' => 'Product reviews.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }


    public function addProductRating(Request $request)
    {

        $validator = Validator::make($request->all(), [

            'product_id' => 'required|string|max:255',
            'review' => 'required', // Testing Values 1,2,3,4,5,6
            'rate' => 'required', // Virtural 1 or Physical 0

        ]);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        try {

        

            $product = Products::find($request->product_id);
            if(empty($product)){

                return response()->json([

                    'success' => false,
                    'data' => "Product not available",
                    'message' => 'error reviews.',
    
                ], 422);

            }
     
   
            
            // return $product;

            $review = ProductRatings::where([
                'id_shop'    => $product->shop_id,
                'id_user'    => auth()->user()->id,
                'id_product' => $request->product_id,
            ])->first();

            if(!empty($review)){
                return response()->json([

                    'success' => false,
                    'data' => ['Rating' => [ "You already rated on this product"]],
                    'message' => 'Rating'
    
                ], 422);
            }
            

            

            // dd($review);
            if(empty($review)){
                $review = new ProductRatings;
            }

           
            

            $review->id_shop    = $product->shop_id;
            $review->id_user    = auth()->user()->id;
            $review->id_product = $request->product_id;
            $review->review     = $request->review;
            $review->rate       = $request->rate;
            // return $review;
            $review->save();
            

            return response()->json([

                'success' => true,
                'data' =>  $review,
                'message' => 'Product reviews.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
