<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\{
    ProductPackages,
    PurchasePackage,
    Transactions,
    Products,
    UserCards,
    Promocodes,
    Shops,
    ProductPromo
};
use Illuminate\Support\Facades\DB;

class PromoCodeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {

            $currentData = date("Y-m-d");
            $data = Promocodes::selectRaw(DB::raw("*,CASE WHEN expires_at >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_expired_status"))
            ->with('productPromoCode.product')
            ->where([
                'vendor_id' => auth()->user()->id
            ])->paginate($request->per_page ? $request->per_page : 12);

            return response()->json([

                'success' => true,
                'data' =>  $data,
                'message' => 'reterive.',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'cart.',

            ], 422);
        }

        //
    }


    public function adminPromoCodelist(Request $request)
    {
        try {

            $currentData = date("Y-m-d");
            $data = Promocodes::selectRaw(DB::raw("*,CASE WHEN expires_at >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_expired_status"))
            ->with('productPromoCode.product')
            ->where([
                'vendor_id' => $request->user_id
            ])->paginate($request->per_page ? $request->per_page : 12);

            return response()->json([

                'success' => true,
                'data' =>  $data,
                'message' => 'reterive.',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'cart.',

            ], 422);
        }

        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $rules = [

            'offer_name' => 'required',
            'promo_code' => 'required',
            'promo_code_percentage' => 'required',
            'promo_code_start_time' => 'required',
            'promo_code_end_time' => 'required'
        ];

        if ($request->all_product == 0) {
            $rules['product'] = 'required';
        }

        $validator = Validator::make($request->all(), $rules);

        $data = $request->all();

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors(),
                'message' => 'error',

            ], 422);
        }


        try {
            $shop = Shops::where(['user_id' => auth()->user()->id])->first();
            $promoCode = Promocodes::create([
                'name'            => $request->offer_name,
                'code'            => $request->promo_code,
                'discount_amount' => $request->promo_code_percentage,
                'starts_at'       => date('Y-m-d h:i:s', strtotime($request->promo_code_start_time)),
                'expires_at'      => date('Y-m-d h:i:s', strtotime($request->promo_code_end_time)) ,
                'vendor_id'       => auth()->user()->id,
                'shop_id'         => $shop->id,
                'is_applied_all' => $request->all_product
            ]);


            if ($request->all_product == 0) {

                foreach($request->product as $product_id){

                    ProductPromo::create([
                        'source_id' => $product_id,
                        'promocode_id' => $promoCode->id
                    ]);
                }

            }


            if ($request->all_product == 1) {

                $productsData  = Products::where([
                    'shop_id' => $shop->id,
                    'status'  => 1,
                ])->get();

                foreach($productsData as $pKey => $valueProduct){

                    ProductPromo::create([
                        'source_id' => $valueProduct->id,
                        'promocode_id' => $promoCode->id
                    ]);
                }

            }


            // foreach($request->product as $product_id){

            //     ProductPromo::create([
            //         'source_id' => $product_id,
            //         'promocode_id' => $promoCode->id
            //     ]);
            // }

            
            return response()->json([

                'success' => true,
                'data'    => $promoCode,
                'message' => 'reterive.',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'error.',

            ], 422);
        }

        //
    }


    public function updatePromoCode(Request $request)
    {

        $rules = [

            'offer_name' => 'required',
            'promo_code' => 'required',
            'promo_code_percentage' => 'required',
            'promo_code_start_time' => 'required',
            'promo_code_end_time' => 'required'
        ];

        if ($request->all_product == 0) {
            $rules['product'] = 'required';
        }

        $validator = Validator::make($request->all(), $rules);

        $data = $request->all();

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors(),
                'message' => 'error',

            ], 422);
        }


        try {
            $shop = Shops::where(['user_id' => auth()->user()->id])->first();
            $promoCode = Promocodes::where('id',$request->id)->update([
                'name'            => $request->offer_name,
                'code'            => $request->promo_code,
                'discount_amount' => $request->promo_code_percentage,
                // 'starts_at'       => $request->promo_code_start_time,
                // 'expires_at'      => $request->promo_code_end_time,
                'starts_at'       => date('Y-m-d h:i:s', strtotime($request->promo_code_start_time)),
                'expires_at'      => date('Y-m-d h:i:s', strtotime($request->promo_code_end_time)) ,
                
                'vendor_id'       => auth()->user()->id,
                'shop_id'         => $shop->id,
                'is_applied_all' => $request->all_product
            ]);

            ProductPromo::where([
                'promocode_id' => $request->id
            ])->delete();


            if ($request->all_product == 0) {

                foreach($request->product as $product_id){

                    ProductPromo::create([
                        'source_id' => $product_id,
                        'promocode_id' => $request->id
                    ]);
                }

            }


            if ($request->all_product == 1) {

                $productsData  = Products::where([
                    'shop_id' => $shop->id,
                    'status'  => 1,
                ])->get();

                foreach($productsData as $pKey => $valueProduct){

                    ProductPromo::create([
                        'source_id' => $valueProduct->id,
                        'promocode_id' => $request->id
                    ]);
                }

            }

            

            
            return response()->json([

                'success' => true,
                'data'    => $promoCode,
                'message' => 'updated facebook.',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'error.',

            ], 422);
        }

        //
    }



    public function viewPromoCode(Request $request)
    {


        try {
            $shop = Shops::where(['user_id' => auth()->user()->id])->first();
            $promoCode = Promocodes::with('productPromoCode')->where('id',$request->id)->first();

         
            
            return response()->json([

                'success' => true,
                'data'    => $promoCode,
                'message' => 'view',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'error.',

            ], 422);
        }

        //
    }


    public function deletePromoCode(Request $request)
    {


        try {
            $shop = Shops::where(['user_id' => auth()->user()->id])->first();
            $promoCode = Promocodes::where('id',$request->id)->delete();

         
            
            return response()->json([

                'success' => true,
                'data'    => $promoCode,
                'message' => 'deleted successfully',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'error.',

            ], 422);
        }

        //
    }



    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
