<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreProductPackagesRequest;
use App\Http\Requests\UpdateProductPackagesRequest;
use App\Models\{
    ProductPackages,
    PurchasePackage,
    Transactions,
    Products,
    UserCards
};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ProductPackagesController extends Controller
{
    static $currency = 'usd';
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {

            $data = ProductPackages::where('status', 1)->get();

            return response()->json([

                'success' => true,
                'data' => $data,
                'message' => 'Product packages',

            ], 200);
            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }

        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function boostProduct(Request $request)
    {
        $validationArr = [

            'package_id' => 'required',
            'product_id' => 'required',

        ];

        if ($request->payment == "other") {

            $validationArr['card_nubmer'] = "required";
            $validationArr['card_month']  = "required";
            $validationArr['card_year']   = "required";
            $validationArr['cvv_number']  = "required";

        }

        $validator = Validator::make($request->all(), $validationArr);

        $data = $request->all();

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }


        try {

            $package = ProductPackages::where('id', $request->package_id)->first();

            if ($request->payment == "other") {

                if ($request->is_save == "yes") {

                    $userCard = self::createUserCard($request);

                    if (!$userCard['success']) {

                        // return $userCard ;

                        return response()->json([

                            'success' => false,
                            'data' =>  ['error' => $userCard['message']],
                            'message' => $userCard['message'],

                        ], 422);
                    }

                    $chargesAmount = self::chargeAmount(['is_save' => 'yes', 'amount' => $package->price, 'customer_id' => $userCard['data']['customer_id']]);
                    if (!isset($chargesAmount['id'])) {

                        return response()->json([

                            'success' => false,
                            'data' => $chargesAmount
                        ], 422);
                    }
                } else {

                    $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET'));

                    $cc = $stripe->tokens->create([
                        'card' => [
                            'number'    => $request->card_nubmer,
                            'exp_month' => $request->card_month,
                            'exp_year'  => $request->card_year,
                            'cvc'       => $request->cvv_number,
                        ],
                    ]);

                    $chargesAmount = self::chargeAmount(['amount' => $package->price, 'stipe_token' => $cc->id]);
                    if (!isset($chargesAmount['id'])) {

                        return response()->json([

                            'success' => false,
                            'data' => $chargesAmount
                        ], 422);
                    }
                }
            }

            if ($request->payment != "other") {
                

                $userCardCheck = UserCards::where(['id' => $request->payment, 'user_id' => auth()->user()->id])->first();
                $chargesAmount = self::chargeAmount(['is_save' => 'yes', 'amount' => $package->price, 'customer_id' => $userCardCheck->customer_id]);
                if (!isset($chargesAmount['id'])) {

                    return response()->json([

                        'success' => false,
                        'data' => $chargesAmount
                    ], 422);
                }
            }





            switch ($package->pack_type) {
                case 'week':
                    $daysForPackage = $package->package_value * 7;
                    break;

                case 'days':
                    # code...
                    $daysForPackage = $package->package_value;
                    break;
                case 'month':

                    $daysInMonth = 30.4167;
                    $daysForPackage = $package->package_value * $daysInMonth;

                    # code...
                    break;
            }

            $p = PurchasePackage::create([
                'product_package_id' => $package->id,
                'amount'             => $package->price,
                'product_id'         => $request->product_id,
                'vendor_id'          => auth()->user()->id,
                'start_date'         => date('Y-m-d h:i:s'),
                'exp_date'           => date('Y-m-d h:i:s', strtotime("+" . $daysForPackage . " days")),
            ]);


            Transactions::create([
                'admin_id' => 1,
                'user_id'  => auth()->user()->id,
                'vendor_id' => auth()->user()->id,
                'amount' => $package->price,
                'source_id' => $p->id,
                'source_type' => 'package',
                'type' => 'deposit',
                'payment_purpose' => 'transferred_from_vendor_to_admin',
                'shop_id' =>   auth()->user()->shop->id,
                'trx_id' =>  $chargesAmount['id'],
                'transaction_text' => ['order_ids' => [], 'trns_text' => 'Prodcut boost payment'],
                'payment_response' => $chargesAmount,
            ]);

            $product = Products::find($request->product_id);
            $product->boost_exp_date  = date('Y-m-d h:i:s', strtotime("+" . $daysForPackage . " days"));
            $product->is_featured = 1;
            $product->save();
            // PurchasePackage::create();

            return response()->json([

                'success' => true,
                'data' =>  'purchased successfully',
                'message' => 'cart.',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'cart.',

            ], 422);
        }

        // PurchasePackage
        //
    }


    public function createUserCard($request, $totalAmount = null)
    {


        try {

            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET'));

            $cc = $stripe->tokens->create([
                'card' => [
                    'number'    => $request->card_nubmer,
                    'exp_month' => $request->card_month,
                    'exp_year'  => $request->card_year,
                    'cvc'       => $request->cvv_number,
                ],
            ]);

            // for save payment methods charge amount
            // if ($request->is_save == "yes") {

            $userCard = UserCards::where(['last4digit' => $cc->card->last4, 'brand' => $cc->card->brand, 'user_id' => auth()->user()->id])->first();

            if (empty($userCard)) {
                $userCard = new UserCards;
            }

            // $userCard->customer_id  = ;
            $userCard->brand        = $cc->card->brand;
            $userCard->last4digit   = $cc->card->last4;
            $userCard->card_details = $cc;
            $userCard->user_id      = auth()->user()->id;
            $userCard->save();


            $userCardCheck = UserCards::where(['last4digit' => $cc->card->last4, 'brand' => $cc->card->brand, 'user_id' => auth()->user()->id])->first();

            $customer = $stripe->customers->create([
                'card'  => $cc->id,
                'description' => auth()->user()->firstname . ' ' . auth()->user()->lastname,
            ]);


            if (!empty($userCardCheck)) {
                $userCardCheck->customer_id = $customer->id;
                $userCardCheck->save();
                // }

                // $chargesAmount = self::chargeAmount(['is_save' => 'yes', 'amount' => $totalAmount, 'customer_id' => $userCardCheck->customer_id]);


                return [
                    'success' => true,
                    'data'    => $userCardCheck,
                    'message' => 'Payment successfully.',
                    'status_code' => 200
                ];
            }
        } catch (\Exception $e) {

            return [
                'success' => false,
                'message' => $e->getMessage(),
                'data' => null,
                'status_code' => 422
            ];
        }
    }


    public function chargeAmount($data = [])
    {
        // dd(self::$currency);
        $stripeCharge = new \Stripe\StripeClient(env('STRIPE_SECRET'));

        if (isset($data['is_save'])) {

            if ($data['is_save'] == "yes") {

                $charge = $stripeCharge->charges->create([
                    'amount'      => $data['amount'] * 100,
                    'currency'    => self::$currency,
                    'customer'    => $data['customer_id'],
                    'description' => 'checkout payment guinee',
                ]);
            }
        } else {

            $charge = $stripeCharge->charges->create([
                'amount'      => $data['amount'] * 100,
                'currency'    => self::$currency,
                'source'      => $data['stipe_token'],
                'description' => 'checkout payment guinee',
            ]);
        }

        return $charge;
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreProductPackagesRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreProductPackagesRequest $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ProductPackages  $productPackages
     * @return \Illuminate\Http\Response
     */
    public function boostList(Request $request)
    {

        try {

            $data = PurchasePackage::where('vendor_id', auth()->user()->id)
                ->with(['product', 'package'])
                ->paginate($request->per_page ? $request->per_page : 12);
            return response()->json([

                'success' => true,
                'data' =>  $data,
                'message' => 'Package purchased list.',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'cart.',

            ], 422);
        }

        //
    }


    public function boostProductView(Request $request)
    {

        try {

            $data = PurchasePackage::where('id',$request->id)->where('vendor_id', auth()->user()->id)
                ->with(['product', 'package'])
                ->first();
            return response()->json([

                'success' => true,
                'data' =>  $data,
                'message' => 'Package purchased list.',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'cart.',

            ], 422);
        }

        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ProductPackages  $productPackages
     * @return \Illuminate\Http\Response
     */
    public function edit(ProductPackages $productPackages)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateProductPackagesRequest  $request
     * @param  \App\Models\ProductPackages  $productPackages
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateProductPackagesRequest $request, ProductPackages $productPackages)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ProductPackages  $productPackages
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProductPackages $productPackages)
    {
        //
    }
}
