<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Cart;
use App\Models\Categories;
use App\Models\Products;
use App\Models\{
    Stock,
    ProductGroup,
    ProductAttributes,
    ShippingCharges,
    OrderNumbers,
    Orders,
    Shops
};
use Illuminate\Support\Facades\Auth;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function userOrders()
    {
        try {

            $orders = OrderNumbers::where('id_user', Auth::user()->id)->orderBy('id','desc')->paginate(12);

            return response()->json([

                'success' => true,
                'data'    => $orders,
                'message' => 'Orders.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }


    public function vendorOrders()
    {
        try {

            $orders = OrderNumbers::with('orders')
            ->withSum('orders', 'sub_total')
            ->withSum('orders', 'discount_sub_total')
            ->where('vendor_id', Auth::user()->id)
            ->orderBy('id','desc')
            ->paginate(12);

            return response()->json([

                'success' => true,
                'data'    => $orders,
                'message' => 'Orders.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }

    public function viewOrder($id)
    {
        try {

            $orders = OrderNumbers::with('orders')
            ->withSum('orders', 'sub_total')
            ->withSum('orders', 'discount_sub_total')
            ->withSum('orders', 'promo_discount_sub_total')
            ->find($id);

            // $orders = Orders::where('id_ordernumber', $id)->get();

            return response()->json([

                'success' => true,
                'data'    => $orders,
                'message' => 'Orders.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }


    public function orderStatusUpdate(Request $request)
    {

        try {

            $orders = OrderNumbers::find($request->id);


            $orders->order_status = $request->status;
            $orders->save();

            // $orders = Orders::where('id_ordernumber', $id)->get();

            return response()->json([

                'success' => true,
                'data'    => $orders,
                'message' => 'Orders status updated successfully',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }

        
        //
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
