<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use App\Models\Cart;
use App\Models\Categories;
use App\Models\Products;
use App\Models\{
    Address,
    Stock,
    ProductGroup,
    ProductAttributes,
    ShippingCharges,
    OrderNumbers,
    Orders,
    Shops,
    UserCards,
    Transactions,
    User,
    Promocodes,
    ProductPromo
};
use Exception;
use Illuminate\Support\Facades\Auth;

class CartController extends Controller
{
    static $currency = 'usd';

    public function addToCart(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'id_product' => 'required',
            'size' => 'string',
            'color' => 'string',
            'quantity' => 'required|numeric',

        ]);

        $data = $request->all();

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        } else {

            $findProduct = Stock::where('id_product', $request->id_product)->get();

            if ($findProduct != null) {
                if (count($findProduct) > 1) {
                    $findStock = Stock::where('id_product', $request->id_product)->where('size', $request->size)->where('color_name', $request->color)->get();

                    if (count($findStock) > 0) {

                        if ($findStock[0]['quantity'] > 1 && ($request->quantity < $findStock[0]['quantity'])) {
                            $cart = Cart::updateOrCreate([

                                'id_stock' => $findStock[0]['id'],
                                'id_user' => auth()->user()->id,

                            ], [

                                'quantity' => $request->quantity,

                            ]);

                            return response()->json([

                                'success' => true,
                                'message' => 'Product added to cart.',

                            ], 200);
                        } else {
                            return response()->json([

                                'success' => false,
                                'data' => 'Product out of stock'

                            ], 422);
                        }
                    } else {
                        return response()->json([

                            'success' => false,
                            'data' => 'Product not found'

                        ], 422);
                    }
                } else {
                    if ($findProduct[0]['quantity'] > 1 && ($request->quantity < $findProduct[0]['quantity'])) {
                        $cart = Cart::updateOrCreate([

                            'id_stock' => $findProduct[0]['id'],
                            'id_user' => auth()->user()->id,

                        ], [

                            'quantity' => $request->quantity,

                        ]);

                        return response()->json([

                            'success' => true,
                            'message' => 'Product added to cart.',

                        ], 200);
                    } else {
                        return response()->json([

                            'success' => false,
                            'data' => 'Product out of stock'

                        ], 422);
                    }
                }
            } else {
                return response()->json([

                    'success' => false,
                    'data' => 'Product not found'

                ], 422);
            }
        }
    }

    public function emptyCart()
    {
        $cart = Cart::where('id_user', auth()->user()->id)->delete();

        return response()->json([

            'success' => true,
            'message' => 'Your cart is empty.',

        ], 200);
    }

    public function deleteCartItem(Request $request)
    {
        $cart = Cart::where('id', $request->id_cart)->delete();

        return response()->json([

            'success' => true,
            'message' => 'Item removed.',

        ], 200);
    }

    public function cartList()
    {
        // $data = Categories::with('products.stocks.cart_items')
        // ->with('products.gallery_images')
        // ->with('products.specifications.metaKey')
        // ->get();

        $cart = Cart::with('stock.product.gallery_images')->where('id_user', auth()->user()->id)->get();

        return response()->json([

            'success' => true,
            'data' => $cart,
            'message' => 'My cart items.',

        ], 200);
    }


    public function checkProductInCart(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'quantity' => 'required|numeric|gt:0',
        ]);


        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        if ($request->product_type == 'variation') {

            if (count($request->attr_array) == 0) {

                return response()->json([

                    'success' => false,
                    'data' => ['variations' => ["Select variations"]],
                    'message' => 'Select variations'

                ], 422);
            }
        }



        $product =  Products::find($request->product_id);

        $productAtr = $product->attributes()->groupBy('id')->get()->pluck('slug');
        $productAtrName = $product->attributes()->groupBy('id')->get();

        // return $productAtrName[];

        $checkValue = collect($request->attr_array)->pluck('attribute_slug')->toArray();

        if ($request->product_type == 'variation') {
            foreach ($productAtrName as $productValue) {

                if (!in_array($productValue['slug'], $checkValue)) {

                    return response()->json([

                        'success' => false,
                        'data' => ['variations' => ["Select " . ucfirst($productValue['name'])]],
                        'message' => 'Select variations'

                    ], 422);
                }
            }
        }

        try {

        //    $attrGallery =  $checkValue = collect($request->attr_array)->map(function($q){
        //         if($q['is_gallary'] == true){
        //             return $q;
        //         }
        //     });
        //     return response()->json([
                

        //         'success' => false,
        //         'data' => $attrGallery[0]['value_id'],
        //         'message' => 'Product is not avaiable',

        //     ], 422);


            $query =  ProductGroup::with([
                'groupOptions',
                'product.gallery_images' => function($gq) use ($request){

                    // dd($request->attr_array);
                    if ($request->product_type == 'variation') {
                        $attrGallery =  $checkValue = collect($request->attr_array)->map(function($q){
                            if($q['is_gallary'] == true){
                                return $q;
                            }
                        });
                        $gq->where(['attr_id' => $attrGallery[0]['attribute_id'] , 'attr_value_id' => $attrGallery[0]['value_id']]);
                    }
                    return $gq;
                },
                'productAttribute.attributes',
                'productAttribute.attribute_value',
                'stockAvailable'
            ])->where('product_id', $request->product_id);


            if ($request->product_type == 'variation') {

                foreach ($request->attr_array as $attrKey => $attrValue) {

                    $query->whereHas('groupOptions', function ($q) use ($attrValue) {

                        return $q->where('attribute_value_id', $attrValue['value_id']);
                    });
                }
            }

            $data =  $query->first();
            // return $data;

            if (empty($data)) {
                return response()->json([

                    'success' => false,
                    'data' => null,
                    'message' => 'Product is not avaiable',

                ], 422);
            }

            $data->sub_total_sale = $request->quantity * $data->sale_price;
            $data->sub_discount_total_sale = $request->quantity * $data->discount_price;

            $data->cart_qty = $request->quantity;
            $data->shop_id = $data->product ? $data->product->shop_id : null;
            $data->car = $data->product ? $data->product->shop_id : null;
            $data->promo_discount_type = 'percentage';
            $data->promo_discount_price = 0;
            $data->promo_percentage = 0;
            $data->ship_charges = null;

            if ($data->product) {
                if ($data->product->shipCharges) {
                    $data->ship_charges = $data->product->shipCharges;
                }
            }


            return response()->json([

                'success' => true,
                'data' => $data,
                'message' => 'cart.',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function checkoutPayment(Request $request)
    {

        // ;

        //  return response()->json([

        //     'success' => false,
        //     'data' => $this->totalCartAmount($request)

        // ], 422);




        // return $userCard = UserCardsController::create($request); 


        //  if ($validator->fails()) {

        // return response()->json([

        //     'success' => false,
        //     'data' => $request->all()

        // ], 422);
        // }



        $valiDateArr = [
            'card_holder' => 'required',
            'card_month'  => 'required',
            'card_nubmer' => 'required',
            'card_year'   => 'required',
            'cvv_year'    => 'required',


            'firstname_s'   => 'required',
            'lastname_s'    => 'required',
            'email_s'       => 'required',
            'phone_s'       => 'required',
            'address_s'     => 'required',
            'city_s'        => 'required',
            'code_s'        => 'required',
            'country_s'     => 'required',


            'cart' => 'required'

        ];

        if (!$request->same_billing_check) {

            $valiDateArr['firstname_b']        = 'required';
            $valiDateArr['lastname_b']         = 'required';
            $valiDateArr['email_b']            = 'required';
            $valiDateArr['phone_b']            = 'required';
            $valiDateArr['address_b']          = 'required';
            $valiDateArr['city_b']             = 'required';
            $valiDateArr['code_b']             = 'required';
            $valiDateArr['country_b']          = 'required';
        }




        // $validator = Validator::make($request->all(), $valiDateArr);

        $cartTotalArray = $this->totalCartAmount($request);



            // return response()->json([

            //     'success' => false,
            //     'data' => $cartTotalArray

            // ], 422);



        // if ($validator->fails()) {

        //     return response()->json([

        //         'success' => false,
        //         'data' => $validator->errors()

        //     ], 422);
        // }

        try {

            if ($request->payment == "payment") {

                if ($request->choose_payment == "other") {

                    if ($request->is_save == "yes") {



                        $userCard = self::createUserCard($request, $cartTotalArray['main_total'] -$cartTotalArray['main_total_promo']);

                        if (!$userCard['success']) {

                            // return $userCard ;

                            return response()->json([

                                'success' => false,
                                'data' =>  'failed',
                                'message' => $userCard['message'],

                            ], 422);
                        }
                    }

                    if ($request->is_save != "yes") {

                        $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET'));

                        $cc = $stripe->tokens->create([
                            'card' => [
                                'number'    => $request->card_nubmer,
                                'exp_month' => $request->card_month,
                                'exp_year'  => $request->card_year,
                                'cvc'       => $request->cvv_number,
                            ],
                        ]);


                        $chargesAmount = self::chargeAmount(['amount' => $cartTotalArray['main_total'] -$cartTotalArray['main_total_promo'], 'stipe_token' => $cc->id]);
                        if (!isset($chargesAmount['id'])) {

                            return response()->json([

                                'success' => false,
                                'data' => $chargesAmount
                            ], 422);
                        }
                    }
                }


                if ($request->choose_payment != "other") {

                    $userCardCheck = UserCards::where(['id' => $request->choose_payment, 'user_id' => auth()->user()->id])->first();
                    $chargesAmount = self::chargeAmount(['is_save' => 'yes', 'amount' => $cartTotalArray['main_total'] - $cartTotalArray['main_total_promo'], 'customer_id' => $userCardCheck->customer_id]);

                    if (!isset($chargesAmount['id'])) {

                        return response()->json([

                            'success' => false,
                            'data' => $chargesAmount,
                            'message' => 'cart.',
                        ], 422);
                    }
                }
            }



            if ($request->select_address == "otheraddress") {


                $address = Address::create([
                    'firstname'   => $request->firstname_s,
                    'lastname'    => $request->lastname_s,
                    'email'       => $request->email_s,
                    'phone'       => $request->phone_s['number'],
                    'address'     => $request->address_s,
                    'city'        => $request->city_s,
                    'code'        => $request->code_s,
                    'country'     => $request->country_s,
                    'id_user'     => auth()->user()->id
                ]);


                $address = Address::find($address->id);




                // return $address;


            }

            if ($request->select_address != "otheraddress") {

                $address = Address::where('id', $request->select_address)->first();
            }




            $carts = collect($request->cart);

            $cartGroupByShops = $carts->groupBy('shop_id');
            $charges = 0;
            $real_shpping_charges = 0;
            foreach ($cartGroupByShops as $keycartGroupByShop => $cartGroupByShop) {

                $shppingCharges = ShippingCharges::where('shop_id', $keycartGroupByShop)->first();



                if (isset($shppingCharges->id)) {



                    if ((float) $shppingCharges->free_shipping > 0) {

                        $charges = $cartTotalArray['shop_sub_total'][$keycartGroupByShop] >= $shppingCharges->free_shipping  ?  0 : $shppingCharges->charges;

                        // $charges = $cartTotalArray['shop_sub_total'][$keycartGroupByShop]  > $shppingCharges->;
                    } else {
                        $charges = $shppingCharges->charges;
                    }


                    $real_shpping_charges = $shppingCharges->charges;

                    //  return $cartGroupByShops[$keycartGroupByShop];

                }



                // update user balance
                if ($request->payment == "payment") {
                    // return $keycartGroupByShop;
                    $shopDataModel = Shops::where('id', $keycartGroupByShop)->first();//CHECKING

                    $userModel = User::where('id', $shopDataModel->user_id)->first();
                    $userModel->balance_amount = $userModel->balance_amount + ($cartTotalArray['shop_sub_total'][$keycartGroupByShop] + $charges) - $cartTotalArray['main_total_promo'];
                    $userModel->save();
                }


                $promoCode = Promocodes::where([
                    'shop_id' => $keycartGroupByShop,
                    // 'shop_id' => $cartGroupByShop['shop_id'],
                    'code' => $request->promo_code,
                ])
                // ->where('expires_at', '>', $currentDate)
                ->first();


                $orderDetails  = [
                    // 'number'             => ,	
                    // 'id_status'          => ,	
                    'id_user'            => auth()->user()->id,
                    'payment_type'       => $request->payment ?? 'cash',
                    'shop_id'            => $keycartGroupByShop,
                    'vendor_id'          => Shops::find($keycartGroupByShop)->user_id,
                    'shpping_charges'    => $charges,
                    'real_shpping_charges' => $real_shpping_charges,


                    'firstname_s'        => $address->firstname,
                    'lastname_s'         => $address->lastname,
                    'email_s'            => $address->email,
                    'phone_s'            => $address->phone,
                    'address_s'          => $address->address,
                    'city_s'             => $address->city,
                    'code_s'             => $address->code,
                    'country_s'          => $address->country,
                    'promocode'          => $request->promo_code,
                    'promocode_id'       => isset($promoCode->shop_id) ? $promoCode->shop_id : null,
                    

                ];


                if ($request->same_billing_check) {

                    $orderDetails['firstname_b']        = $address->firstname;
                    $orderDetails['lastname_b']         = $address->lastname;
                    $orderDetails['email_b']            = $address->email;
                    $orderDetails['phone_b']            = $address->phone;
                    $orderDetails['address_b']          = $address->address;
                    $orderDetails['city_b']             = $address->city;
                    $orderDetails['code_b']             = $address->code;
                    $orderDetails['country_b']          = $address->country;
                } else {


                    $orderDetails['firstname_b']        = $request->firstname_b;
                    $orderDetails['lastname_b']         = $request->lastname_b;
                    $orderDetails['email_b']            = $request->email_b;
                    $orderDetails['phone_b']            = $request->phone_s['number'];
                    $orderDetails['address_b']          = $request->address_b;
                    $orderDetails['city_b']             = $request->city_b;
                    $orderDetails['code_b']             = $request->code_b;
                    $orderDetails['country_b']          = $request->country_b;
                }


                $orderNumber = OrderNumbers::create($orderDetails);
                $updateOrderNumber = OrderNumbers::find($orderNumber->id)->update(['number' => $orderNumber->id . rand(0, 9999)]);

                $shopData = Shops::where('id', $keycartGroupByShop)->first();

                $trxId = "";
                $trxData = "";

                if (isset($chargesAmount['id'])) {
                    $trxId = $chargesAmount['id'];
                    $trxData = $chargesAmount;
                }

                if (isset($userCard['data'])) {
                    $trxId = $userCard['data']['id'];
                    $trxData = $userCard['data'];
                }




                Transactions::create([
                    'admin_id' => 1,
                    'user_id'  => auth()->user()->id,
                    'vendor_id' => $shopData->user_id,
                    'amount' => ($cartTotalArray['shop_sub_total'][$keycartGroupByShop] + $charges) - $cartTotalArray['sub_main_total_promo'][$keycartGroupByShop],
                    'source_id' => $orderNumber->id,
                    'source_type' => 'order',
                    'type' =>  $request->payment == 'payment' ? 'deposit' : 'cash',
                    'payment_purpose' => 'transferred_from_vendor_to_admin',
                    'shop_id' =>  $keycartGroupByShop,
                    'trx_id' =>  $trxId,
                    'transaction_text' => ['order_ids' => [$orderNumber->id], 'trns_text' => ' order no 1 '],
                    'payment_response' => $trxData,
                ]);

                // Transactions::create();
                // Orders

                foreach ($cartGroupByShops[$keycartGroupByShop] as $keyItem => $itemvalue) {

                    $product_details  =   ProductGroup::with(['product.gallery_images', 'productAttribute.attributes'])
                        ->with(['productAttribute.attribute_value.galleryImagesVariant'])
                        ->find($itemvalue['id']);

                    $stockUpdate = Stock::where(['id_product' => $itemvalue['product_id'], 'product_group_id' => $itemvalue['id']])->first();
                    if (!empty($stockUpdate)) {

                        $stockUpdate->quantity = $stockUpdate->quantity - $itemvalue['cart_qty'];
                        $stockUpdate->save();
                    }


                    Orders::create([
                        'id_ordernumber'      => $orderNumber->id,
                        'group_id'            => $itemvalue['id'],
                        // 'sub_total'           => $itemvalue['sub_total_sale'],
                        'sub_total'           => $product_details->discount_price < 1 ?  $itemvalue['cart_qty'] * $product_details->sale_price : 0,
                        'discount_sub_total'  => $itemvalue['cart_qty'] * $product_details->discount_price,
                        'order_json'     => $product_details,
                        'product_id'     => $itemvalue['product_id'],
                        'quantity'       => $itemvalue['cart_qty'],
                        'promo_discount_sub_total' => $itemvalue['promo_discount_price'],
                        'promo_discount_value'     => $itemvalue['promo_percentage'],
                        'promo_discount_type'      => $itemvalue['promo_discount_type'],
                    ]);
                }
            }


            return response()->json([

                'success' => true,
                'data' =>  'checkout successfully',
                'message' => 'cart.',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'cart.',

            ], 422);
        }
    }


    public function totalCartAmount($request)
    {

        $carts = collect($request->cart);

        $cartGroupByShops = $carts->groupBy('shop_id');
        $charges = 0;
        $real_shpping_charges = 0;
        $sub_total = 0;
        $discount_sub_total = 0;
        $main_total = 0;
        $main_total_promo = 0;
        $shopSubTotal = [];
        $sub_main_total_promo = [];
        $subTotalShopMerge = 0;
        foreach ($cartGroupByShops as $keycartGroupByShop => $cartGroupByShop) {

            $shppingCharges = ShippingCharges::where('shop_id', $keycartGroupByShop)->first();



            // Orders



            foreach ($cartGroupByShops[$keycartGroupByShop] as $keyItem => $itemvalue) {

                $product_details  =   ProductGroup::with(['product.gallery_images', 'productAttribute.attributes'])
                    ->with(['productAttribute.attribute_value.galleryImagesVariant'])
                    ->find($itemvalue['id']);

                $sub_total += $product_details->discount_price < 1 ?  $itemvalue['cart_qty'] * $product_details->sale_price : 0;
                $discount_sub_total  += $itemvalue['cart_qty'] * $product_details->discount_price;

                $main_total_promo = $main_total_promo+$itemvalue['promo_discount_price'];

                $sub_main_total_promo[$keycartGroupByShop]  = $itemvalue['promo_discount_price'];
                $subTotalShopMerge += (($product_details->discount_price < 1 ?  $itemvalue['cart_qty'] * $product_details->sale_price : 0) + ($itemvalue['cart_qty'] * $product_details->discount_price));
                // $shopSubTotal[$keycartGroupByShop] = ($product_details->discount_price < 1 ?  $itemvalue['cart_qty'] * $product_details->sale_price : 0) + ($itemvalue['cart_qty'] * $product_details->discount_price);
                $shopSubTotal[$keycartGroupByShop] = $subTotalShopMerge;
            }

            if (isset($shppingCharges->id)) {

                if ($shppingCharges->free_shipping != 0) {
                    $charges += ($sub_total + $discount_sub_total) > $shppingCharges->free_shipping  ?  0 : $shppingCharges->charges;
                } else {
                    $charges += $shppingCharges->charges;
                }
                $real_shpping_charges = $shppingCharges->charges;
            }
        }

        $main_total = $sub_total + $discount_sub_total + $charges;

        return [
            'main_total'             => $main_total,
            'main_total_promo'       => $main_total_promo,
            'sub_total'              => $sub_total,
            'discount_sub_total'     => $discount_sub_total,
            'sippning_charges_total' => $charges,
            'shop_sub_total'         => $shopSubTotal,
            'sub_main_total_promo'   => $sub_main_total_promo
        ];
    }


    public function createUserCard($request, $totalAmount)
    {

        // $validator = Validator::make($request->all(), [

        //     'name' => 'required|string|max:25',
        //     'about_shop' => 'required|string|max:255',
        //     'id_shop_niche' => 'required', // Testing Values 1,2,3,4,5,6
        //     'shop_type' => 'required|boolean|in:0,1', // Virtural 1 or Physical 0
        //     'logo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        //     'street_address' => 'required|string|max:255',
        //     'suite_apt' => 'nullable|string',
        //     'city' => 'required|string',
        //     'state' => 'required|string',
        //     'zip' => 'required|string',

        // ]);

        // $data = $request->all();

        // if ($validator->fails()) {

        //     return response()->json([

        //         'success' => false,
        //         'data' => $validator->errors()

        //     ], 422);
        // }


        // return [
        //     'success' => false,
        //     'message' =>  env('STRIPE_SECRET'),
        //     'data' => null,
        //     'status_code' => 422
        // ];


        try {

            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET'));

            $cc = $stripe->tokens->create([
                'card' => [
                    'number'    => $request->card_nubmer,
                    'exp_month' => $request->card_month,
                    'exp_year'  => $request->card_year,
                    'cvc'       => $request->cvv_number,
                ],
            ]);

            // for save payment methods charge amount
            // if ($request->is_save == "yes") {

            $userCard = UserCards::where(['last4digit' => $cc->card->last4, 'brand' => $cc->card->brand, 'user_id' => auth()->user()->id])->first();

            if (empty($userCard)) {
                $userCard = new UserCards;
            }

            // $userCard->customer_id  = ;
            $userCard->brand        = $cc->card->brand;
            $userCard->last4digit   = $cc->card->last4;
            $userCard->card_details = $cc;
            $userCard->user_id      = auth()->user()->id;
            $userCard->save();


            $userCardCheck = UserCards::where(['last4digit' => $cc->card->last4, 'brand' => $cc->card->brand, 'user_id' => auth()->user()->id])->first();

            $customer = $stripe->customers->create([
                'card'  => $cc->id,
                'description' => auth()->user()->firstname . ' ' . auth()->user()->lastname,
            ]);


            if (!empty($userCardCheck)) {
                $userCardCheck->customer_id = $customer->id;
                $userCardCheck->save();
                // }

                $chargesAmount = self::chargeAmount(['is_save' => 'yes', 'amount' => $totalAmount, 'customer_id' => $userCardCheck->customer_id]);

                if (isset($chargesAmount['id'])) {

                    // Transactions::create([
                    //     'admin_id' => 1,
                    //     'vendor_id' => 1,
                    //     'amount' => 1,
                    //     'source_id' => 1,
                    //     'source_type' => 'order',
                    //     'payment_purpose' => 'transferred_from_vendor_to_admin',
                    //     'shop_id' =>  1,
                    //     'trx_id' =>  $chargesAmount['id'],
                    //     'transaction_text' => json_encode(['order_ids'=> [1,2] , 'trns_text' => ' order no 1 ']) ,
                    //     'payment_response' => null,
                    // ]);

                }

                return [
                    'success' => true,
                    'data'    => $chargesAmount,
                    'message' => 'Payment successfully.',
                    'status_code' => 200
                ];
            }


            // $chargesAmount = self::chargeAmount(['is_save' => 'no', 'amount' => 100, 'stipe_token' => $cc->id]);

            // return [

            //     'success' => true,
            //     'message' => 'loaded successfully.',
            //     'data' => $chargesAmount,
            //     'status_code' => 200

            // ];

            //code...
        } catch (\Exception $e) {

            return [
                'success' => false,
                'message' => $e->getMessage(),
                'data' => null,
                'status_code' => 422
            ];
        }
    }

    public function chargeAmount($data = [])
    {
        // dd(self::$currency);
        $stripeCharge = new \Stripe\StripeClient(env('STRIPE_SECRET'));

        if (isset($data['is_save'])) {

            if ($data['is_save'] == "yes") {

                $charge = $stripeCharge->charges->create([
                    'amount'      => $data['amount'] * 100,
                    'currency'    => self::$currency,
                    'customer'    => $data['customer_id'],
                    'description' => 'checkout payment guinee',
                ]);
            }
        } else {

            $charge = $stripeCharge->charges->create([
                'amount'      => $data['amount'] * 100,
                'currency'    => self::$currency,
                'source'      => $data['stipe_token'],
                'description' => 'checkout payment guinee',
            ]);
        }

        return $charge;
    }


    public function vendorTransactionHistory(Request $request)
    {

        try {

            // $data = Transactions::where('vendor_id',auth()->user()->id)->paginate($request->per_page ? $request->per_page : 12);
            $data = Transactions::where('vendor_id', auth()->user()->id)->with([
                'user', 'vendor',
                'order' => function ($oq) {

                    return $oq->whereHas('transaction', function ($oqt) {
                        return $oqt->where('source_type', 'order');
                    });
                },
                'purchasePackages' => function ($qp) {
                    return $qp->whereHas('transaction', function ($pt) {
                        return $pt->where('source_type', 'package');
                    });
                }, 'purchasePackages.package'
            ])
                ->orderBy('id', 'desc')
                ->paginate($request->per_page ? $request->per_page : 12);
                
            $data_collect = $data->toArray();

            $total_earning_order = Transactions::where('vendor_id', auth()->user()->id)->where('source_type', 'order')->sum('amount');
            $total_package_invest = Transactions::where('vendor_id', auth()->user()->id)->where('source_type', 'package')->sum('amount');
            $total_earning_order_payment = Transactions::where('vendor_id', auth()->user()->id)->where(['source_type' => 'order', 'type' => 'deposit'])->sum('amount');
            $total_earning_order_cash = Transactions::where('vendor_id', auth()->user()->id)->where(['source_type' => 'order', 'type' => 'cash'])->sum('amount');


            $data_collect['user_balance']  = auth()->user()->balance_amount;
            $data_collect['total_earning_order'] = $total_earning_order;
            $data_collect['total_earning_order_payment'] = $total_earning_order_payment;
            $data_collect['total_earning_order_cash'] = $total_earning_order_cash;
            $data_collect['total_package_invest'] = $total_package_invest;

            // $data['data']['asdasdad'] = 10000000000000;

            return response()->json([
                'status'  => true,
                'data'    => $data_collect,
                'message' => 'Product Search Successfully'
            ], 200);
        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
    }


    public function vendorTransactionHistoryView(Request $request)
    {

        try {

            // $data = Transactions::where('vendor_id',auth()->user()->id)->paginate($request->per_page ? $request->per_page : 12);
            $data = Transactions::where(['vendor_id' => auth()->user()->id, 'id' => $request->id])->with([
                'user', 'vendor',
                'order' => function ($oq) {

                    return $oq->whereHas('transaction', function ($oqt) {
                        return $oqt->where('source_type', 'order');
                    });
                },
                'purchasePackages' => function ($qp) {
                    return $qp->whereHas('transaction', function ($pt) {
                        return $pt->where('source_type', 'package');
                    });
                }, 'purchasePackages.product', 'purchasePackages.package'
            ])
                ->orderBy('id', 'desc')
                ->first();

            return response()->json([
                'status'  => true,
                'data'    => $data,
                'message' => 'Product Search Successfully'
            ], 200);
        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
    }

    public function checkPromocoeShop(Request $request){

        try {

            $totalPromoDiscounAmount = 0;

            $currentDate = date('Y-m-d');

            $promoCode = Promocodes::where([
                // 'shop_id' => $cartGroupByShop['shop_id'],
                'code' => $request->promocode,
            ])
            ->where('expires_at', '>', $currentDate)
            ->first();

            if(empty($promoCode)){
                return response()->json([
                    'status'  => false,
                    'data'    => ['error'=>['Invalid promo code']],
                    'message' => 'error occurred'
                ], 422);
            }


            $carts =  $request->cart;

            // $cartGroupByShops = $carts->groupBy('shop_id');
            // $charges = 0;
            // $real_shpping_charges = 0;
            foreach ($carts as $keycart => $cartGroupByShop) {

                $promoCode = Promocodes::where([
                    'shop_id' => $cartGroupByShop['shop_id'],
                    // 'product_id' => $cartGroupByShop['product_id'],
                    'code' => $request->promocode,
                ])
                ->whereHas('productPromoCode',function($pd) use($cartGroupByShop){
                    return $pd->where('source_id',$cartGroupByShop['product_id'])->where('source_type','product');
                })
                ->where('expires_at', '>', $currentDate)
                ->first();

                // if(isset($promoCOde->id)){

                // }


                $productPrice = $cartGroupByShop['discount_price'] < 1 ?  $cartGroupByShop['cart_qty'] * $cartGroupByShop['sale_price'] : $cartGroupByShop['cart_qty'] * $cartGroupByShop['discount_price'];

                // $carts[$keycart]['shop_id'] = 121111;


                $totalPromoDiscounAmount += isset($promoCode->id) ? ($promoCode->discount_amount/100) * $productPrice : 0;

                $carts[$keycart]['promo_discount_price'] = isset($promoCode->id) ? ($promoCode->discount_amount/100) * $productPrice : 0;
                $carts[$keycart]['promo_percentage'] = isset($promoCode->id) ? $promoCode->discount_amount : 0;
                // $carts[$keycart]['shop_id'] = ;
                // $carts[$keycart]['shop_id'] = ;
                    
                // $cartGroupByShop['shop_id'] = 1111;
                // $cartGroupByShop['asdasasdsad'] = "adsad";


                // promo_discount_price: 0
                // promo_discount_type: "percentage"
                // promo_percentage: 0


                // return response()->json([
                //     'status'  => true,
                //     'data'    => $promoCode,
                //     'message' => 'Product Search Successfully'
                // ], 200);


            }
            if($totalPromoDiscounAmount == 0){

                return response()->json([
                    'status'  => false,
                    'data'    => ['invalid' => 'Invalid promo code'],
                    'message' => 'error occurred'
                ], 422);

            }
            return response()->json([
                'status'  => true,
                'data'    => $carts,
                'message' => 'Product promo applied Successfully'
            ], 200);
        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
        
    }
}
