<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class AuthController extends Controller
{
    public function register(Request $request) //USER REGISTRATION
    {
        $validator = Validator::make($request->all(), [

            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|string|min:6',
            'phone' => 'required',
            'avatar' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'status' => 'required|in:0,1',
            'role' => 'required|in:1,2,3', //Admin, Vendor, Customer

        ]);

        $data = $request->all();

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        } else {

            if ($request->has('password')) {
                $role = null;
                $filename = time() . '.' . request()->avatar->getClientOriginalExtension();
                $request->avatar->move(public_path('uploads'), $filename);

                $user = User::create([

                    'firstname' => $data['firstname'],
                    'lastname' => $data['lastname'],
                    'email' => $data['email'],
                    'password' => Hash::make($data['password']),
                    'phone' => $data['phone'],
                    'avatar' => '/uploads/' . $filename,
                    // 'status' => $data['status'] ?? 1,
                    'status' =>  1,
                    'store_validate' => 0 // 0 For Customers and For Vendors Who Did Not Create Store After Account Creating, 1 For Vendor Who Created Their Store

                ]);

                if ($data['role'] == 1) {
                    $role = 'Admin';
                } else if ($data['role'] == 2) {
                    $roleToAssignc = Role::where('name', 'Customer')->first();
                    $user->assignRole([$roleToAssignc->id]);
                    $role = 'Vendor';
                } else if ($data['role'] == 3) {
                    $role = 'Customer';
                }

                $roleToAssign = Role::where('name', $role)->first();
                $user->assignRole([$roleToAssign->id]);
                $token = $user->createToken('API Token')->plainTextToken;
                $user->role =  $user->roles->pluck('name');

                return response()->json([

                    'success' => true,
                    'message' => $role . ' registered successfully.',
                    'data' => $user,
                    'token' => $token

                ], 200);
            }
        }
    }

    public function login(Request $request)
    {
        $attr = $request->validate([
            'email' => 'required|string|email',
            'password' => 'required|string|min:6'
        ]);

        if (!Auth::attempt(['email' => $request->email, 'password' => $request->password, 'status' => 1])) {
            return response()->json([

                'success' => false,
                'message' => 'Credentials not match.',

            ], 401);
        }

        $token = auth()->user()->createToken('API Token')->plainTextToken;
        $user = Auth::user();
        $user->role =  $user->roles->pluck('name');
        $user->user_shop = $user->shop;
        return response()->json([

            'success' => true,
            'message' => 'Login successfull.',
            'data' => $user,
            'token' => $token

        ], 200);
    }



    public function updateUsers(Request $request) //USER REGISTRATION
    {
        // $validator = Validator::make($request->all(), [

        //     'firstname' => 'required|string|max:255',
        //     'lastname' => 'required|string|max:255',
        //     'email' => 'required|email|unique:users,email',
        //     'password' => 'required|string|min:6',
        //     'phone' => 'required',
        //     'avatar' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        //     'status' => 'required|in:0,1',
        //     'role' => 'required|in:1,2,3', //Admin, Vendor, Customer

        // ]);

        // $data = $request->all();

        // if ($validator->fails()) {

        //     return response()->json([

        //         'success' => false,
        //         'data' => $validator->errors()

        //     ], 422);
        // }

        $data = $request->all();

        $userArr = [
            'firstname' => $data['firstname'],
            'lastname'  => $data['lastname'],
            // 'email'     => $data['email'],
            'phone'     => $data['phone'],
            'status'    => $data['status'] ?? 1,
            // 'store_validate' => 0 // 0 For Customers and For Vendors Who Did Not Create Store After Account Creating, 1 For Vendor Who Created Their Store
        ];

        if ($request->has('password')) {
            if(!empty($request->password)){
                $userArr['password'] = Hash::make($data['password']);
            }
            
        }

        if ($request->avatar) {
            $filename = time() . '.' . request()->avatar->getClientOriginalExtension();
            $request->avatar->move(public_path('uploads'), $filename);
            $userArr['avatar'] = '/uploads/' . $filename;
        }


        $user = User::find(Auth::user()->id);
        $user->update($userArr);

        $user = User::find(Auth::user()->id);


        return response()->json([
            'success' => true,
            'message' => 'updated successfully.',
            'data' =>  $user,
        ], 200);
    }



    public function userProfile(Request $request)
    {
        try {

            $user = Auth::user();
            $user->role =  $user->roles->pluck('name');

            return response()->json([

                'success' => true,
                'message' => 'successfull.',
                'data' => $user,

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function userShop(Request $request)
    {
        try {

            $user = User::find(Auth::user()->id);
            $user->store_validate = 1;
            $user->role =  $user->roles->pluck('name');
            $user->load('shop.address');

            return response()->json([

                'success' => true,
                'message' => 'Login successfull.',
                'data' => $user,

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
    }




    public function logout()
    {
        auth()->user()->tokens()->delete();
        $code = 200;

        return response()->json([

            'success' => true,
            'message' => 'Logout successfully.',

        ], $code);
    }
}
