<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreAttributesRequest;
use App\Http\Requests\UpdateAttributesRequest;
use Illuminate\Support\Facades\Validator;
use App\Models\Attributes;
use App\Models\AttributeValues;
use Illuminate\Http\Request;


class AttributesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {

            $data = Attributes::where('user_id', auth()->user()->id)->with('attributeValues')->groupBy('name')->get();

            return response()->json([

                'success' => true,
                'data' => $data,
                'message' => 'record  retrieve successfully',

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *``
     * @param  \App\Http\Requests\StoreAttributesRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreAttributesRequest $request)
    {
        try {

            return  $request->store();
        } catch (\Throwable $th) {
            //throw $th;
        }
        //.

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Attributes  $attributes
     * @return \Illuminate\Http\Response
     */
    public function show(Attributes $attributes)
    {
        //

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Attributes  $attributes
     * @return \Illuminate\Http\Response
     */
    public function edit(Attributes $attributes)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateAttributesRequest  $request
     * @param  \App\Models\Attributes  $attributes
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateAttributesRequest $request, Attributes $attributes)
    {
        try {

            return  $request->update($attributes);
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }


    public function updateOption(Request $request, Attributes $attributes)
    {

        $validator = Validator::make($request->all(), [
            'attribute_id' => 'required',
            'id' => 'required'
        ]);



        $attributeValueCheck = Attributes::where('user_id', auth()->user()->id)
            ->whereHas('attributeValues', function ($q) use ($request) {
                return $q->where('value', $request->value);
            })
            ->get();

        if (count($attributeValueCheck) > 0) {

            return response()->json([

                'success' => false,
                'data' => ['error' => ['value already exits']]
            ], 422);
        }

        if ($validator->fails()) {
            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        try {

            $attribute = $attributes::where(['id' => $request->attribute_id, 'user_id' =>  auth()->user()->id])->first();
            $data = AttributeValues::where(['id' => $request->id, 'attribute_id' => $attribute->id])->first();
            $data->update(['value' => $request->value]);

            return response()->json([
                'success' => true,
                'data' => $data,
                'message' => 'Attribute value updated successfully',
            ], 200);
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }



    public function getOptionById(Request $request, $optionId,  Attributes $attributes)
    {

        try {

            // $attribute = $attributes::where(['id' => $attribute_id, 'user_id' =>  auth()->user()->id])->first();
            $data = AttributeValues::where(['id' => $optionId])->first();

            return response()->json([
                'success' => true,
                'data' => $data,
                'message' => 'Attribute reterive successfully',
            ], 200);
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }

    public function getAttributeById(Request $request, $attributeId,  Attributes $attributes)
    {

        try {

            $data = $attributes::where(['id' => $attributeId, 'user_id' =>  auth()->user()->id])->with('attributeValues')->first();
            return response()->json([
                'success' => true,
                'data' => $data,
                'message' => 'Attribute reterive successfully',
            ], 200);
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Attributes  $attributes
     * @return \Illuminate\Http\Response
     */
    public function destroy(Attributes $attributes)
    {
        //
    }
}
