<?php

namespace App\Http\Controllers;

use App\Models\Categories;
use App\Models\ShopAddress;
use App\Models\Shops;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class AdminShopsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $query = Shops::select('*')
        ->with('user')
        ->orderBy('id', 'desc');

        if(!empty($request->title)){
            $query->where("name", "like", "%{$request->title}%");
        }

        $shops = $query->paginate(10);
        return response()->json([

            'success' => true,
            'data' => $shops,
            'message' => 'All Shops with Users.',

        ], 200);
    }

    public function getShop($id)
    {
        try {
            $shop = Shops::where('id', $id)->with('address')->first();

            return response()->json([

                'success' => true,
                'data' => $shop,
                'message' => 'Single Shop',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function profileShop($id)
    {
        try {
            $shop = Shops::where('user_id', $id)->with('address', 'user')->first();

            return response()->json([

                'success' => true,
                'data' => $shop,
                'message' => 'Single Shop',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $validator = Validator::make($request->all(), [

            'name' => 'required|string|max:25',
            'about_shop' => 'required|string|max:255',
            'id_shop_niche' => 'required', // Testing Values 1,2,3,4,5,6
            'shop_type' => 'required|boolean|in:0,1', // Virtural 1 or Physical 0
            'street_address' => 'required|string|max:255',
            'suite_apt' => 'nullable|string',
            'city' => 'required|string',
            'state' => 'required|string',
            'zip' => 'required|string',
            'shop_id' => 'required',
        ]);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }
        try {
            $shop = Shops::find($id);

            $shop->name = $request->name;
            $shop->about_shop = $request->about_shop;
            $shop->id_shop_niche = $request->id_shop_niche;
            $shop->shop_type = $request->shop_type;
            // $shop->status = 0;

            if ($request->hasFile('logo')) {

                $filename = time() . '.' . request()->logo->getClientOriginalExtension();
                $request->logo->move(public_path('uploads'), $filename);
                $shop->logo = '/uploads/' . $filename;
            }

            if ($request->cover_photo) {
                $filenameCover = 'cover'.time() . '.' . request()->cover_photo->getClientOriginalExtension();
                $request->cover_photo->move(public_path('uploads'), $filenameCover);
                $shop->cover_photo = '/uploads/' . $filenameCover;

            }

            $shop->update();

            $shopAddress = ShopAddress::where('shop_id', $request->shop_id)->first();

            $shopAddress->address_type = "Main";
            $shopAddress->street_address = $request->street_address;
            $shopAddress->suite_apt = $request->suite_apt;
            $shopAddress->city = $request->city;
            $shopAddress->state = $request->state;
            $shopAddress->zip = $request->zip;
            $shopAddress->latitude = 37.09;
            $shopAddress->longitude = 95.71;
            $shopAddress->status = 1;
            $shopAddress->update();

            $shop = Shops::where(["id" => $shop->id])->with('address')->first();

            return response()->json([

                'success' => true,
                'data' => $shop,
                'message' => 'Shop Updated Successfully.',

            ], 200);

        } catch (\Throwable $th) {
            return $th;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function shopStatusUpdate(Request $request){
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'status' => 'required', // approved 1 or pending 0
        ]);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        $shop = Shops::find($request->id);
        $shop->status = $request->status;
        $shop->update();

        $user = User::find($shop->user_id);
        $user->status = $request->status;
        $user->update();

        $shopStatus = Shops::with('user')->find($request->id);

        return response()->json([

            'success' => true,
            'data' => $shopStatus,
            'message' => 'Shop and Vendor Status Updated Successfully.',

        ], 200);
    }
}
