<?php

namespace App\Http\Controllers;

use App\Models\{OrderNumbers, Orders, ProductRatings, Products, PurchasePackage};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class AdminProductsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $query = Products::with('shop', 'category', 'shop.user')
        ->orderBy('id', 'desc');
        if(!empty($request->title)){
            $query->where("name", "like", "%{$request->title}%");
        }

        $products = $query->paginate(10);
        return response()->json([

            'success' => true,
            'data' => $products,
            'message' => 'All products retrieves.',

        ], 200);
    }

    public function getProduct($id)
    {
        try {
            $products = Products::with('shop', 'shop.user', 'category', 'category.parentMember', 'gallery_images')->where('id', $id)->first();

            return response()->json([

                'success' => true,
                'data' => $products,
                'message' => 'Single Shop',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function productsRating($id)
    {
        try {
            $orders = OrderNumbers::with('orders')
            ->with('orders.singleRating')
            ->withSum('orders', 'sub_total')
            ->find($id);

            return response()->json([

                'success' => true,
                'data' => $orders,
                'message' => 'Products with Ratings',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }


    public function productListAdminBoosting(Request $request)
    {
        // $user_id = auth()->user()->id;
        // $currentData = date("Y-m-d");
        // $productList = Products::selectRaw(DB::raw("*,CASE WHEN DATE_FORMAT(boost_exp_date,'%Y-%m-%d') >= DATE_FORMAT('$currentData','%Y-%m-%d')  THEN 1 else 0 END as is_featured_status"))
        // ->with(['productGroup', 'shop'])->with('category')->with('gallery_images')->with('specifications')
        //     ->whereHas('shop', function ($query) use ($request) {
        //         $query->where('user_id', $request->user_id);
        //     })
        //     ->withCount(['productRatings as average_rating' => function ($query) {
        //         return $query->select(DB::raw('ROUND(coalesce(avg(rate),0),1)'));
        //     }])
        //     ->having('is_featured_status','>',0)
        //     ->paginate($request->per_page ? $request->per_page : 5);

        
        try {

            $data = PurchasePackage::where('vendor_id', $request->user_id)
                ->with(['product', 'package'])
                ->paginate($request->per_page ? $request->per_page : 5);
            return response()->json([

                'success' => true,
                'data' =>  $data,
                'message' => 'Package purchased list.',

            ], 200);

            //code...
        } catch (\Exception $e) {

            return response()->json([

                'success' => false,
                'data' => ['error' => $e->getMessage()],
                'message' => 'cart.',

            ], 422);
        }

            
        return response()->json([

            'success' => true,
            'data' => $data,
            'message' => 'Product List.',

        ], 200);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $validator = Validator::make($request->all(), [

            'name' => 'required|string',
            'short_description' => 'required|string|max:255',
            'long_description' => 'required|string',
        ]);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        try {
            $product = Products::find($id);

            $product->name = $request->name;
            $product->short_description = $request->short_description;
            $product->long_description = $request->long_description;
            $product->update();

            return response()->json([

                'success' => true,
                'data' => $product,
                'message' => 'Product Updated Successfully.',

            ], 200);
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function productStatusUpdate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'status' => 'required|boolean|in:0,1', // approved 1 or pending 0
        ]);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }
        $product = Products::find($request->id);
        $product->status = $request->status;
        $product->update();

        return response()->json([

            'success' => true,
            'data' => $product,
            'message' => 'Product Status Updated Successfully.',

        ], 200);
    }

    public function userProducts($id)
    {
        $products = Products::where('shop_id', $id)->with('category', 'gallery_images')->orderBy('id', 'desc')->paginate(5);
        return response()->json([

            'success' => true,
            'data' => $products,
            'message' => 'Shop products retrieves.',

        ], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function productsFilter(Request $request)
    {
        // return $request->all();
        $products = Products::with("category")->where("name", "like", "%{$request->title}%")->get();

        return response()->json([

            'success' => true,
            'data' => $products,
            'message' => 'FIlter Products retrieves.',

        ], 200);
    }
}
