<?php

namespace App\Http\Controllers;

use App\Models\{Categories, OrderNumbers, Orders, Products, Shops, User};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\{
    Address,
    Stock,
    ProductGroup,
    ProductAttributes,
    ShippingCharges,
    UserCards,
    Transactions,
};
use Exception;

class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function orders()
    {
        try {

            // $orders = OrderNumbers::with("orders")->paginate(10);
            $orders = Orders::paginate(10);

            return response()->json([

                'success' => true,
                'data'    => $orders,
                'message' => 'Orders.',

            ], 200);
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function shopOrders($id)
    {
        try {

            $orders = OrderNumbers::where('shop_id', $id)->orderBy('id', 'desc')->paginate(5);

            return response()->json([

                'success' => true,
                'data'    => $orders,
                'message' => 'Orders.',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function userOrders($id)
    {
        try {

            $orders = OrderNumbers::where('id_user', $id)->orderBy('id', 'desc')->paginate(5);

            return response()->json([

                'success' => true,
                'data'    => $orders,
                'message' => 'Orders.',

            ], 200);
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function userOrderDetails($id)
    {
        try {
            $orderFirst = OrderNumbers::with('orders')

                ->withSum('orders', 'sub_total')
                ->withSum('orders', 'discount_sub_total')
                ->withSum('orders', 'promo_discount_sub_total')
                // ->whereHas('orders', function ($q) use ($id) {
                //     return $q->where('id_ordernumber', $id);
                // })
                ->where('id',$id)->first();
            $orderDetails = OrderNumbers::with('orders')
                // ->where('id_user', )
                ->with(['orders.singleRating' => function($r) use ($orderFirst){
                    return $r->where('id_user',$orderFirst->id_user);
                }])
                ->withSum('orders', 'sub_total')
                ->withSum('orders', 'discount_sub_total')
                ->withSum('orders', 'promo_discount_sub_total')
                // ->whereHas('orders', function ($q) use ($id) {
                //     return $q->where('id_ordernumber', $id);
                // })
                ->where('id',$id)
                ->paginate(10);

            // $orderDetails = OrderNumbers::with("orders")->whereHas('orders', function($q) use($id){
            //     return $q->where('id_ordernumber', $id);
            // })->paginate(10);

            return response()->json([

                'success' => true,
                'data'    => $orderDetails,
                'message' => 'Orders.',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function customers(Request $request)
    {
        try {

            // $query = User::where('store_validate', 0)
            // ->orderBy('id', 'desc');
            $query = User::with('roles')->orderBy('id', 'desc');

            if(!empty($request->title)){
                $query->where("firstname", "like", "%{$request->title}%");
            }

            // $query->whereHas('roles', function($q) {
            //     $q->whereIn('name' , ['Vendor','Customer']);
            // });

            $customers = $query->paginate(10);

            return response()->json([

                'success' => true,
                'data'    => $customers,
                'message' => 'Users.',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function vendors()
    {
        try {

            $vendors = User::with("shop")->where('store_validate', 1)->paginate(10);

            return response()->json([

                'success' => true,
                'data'    => $vendors,
                'message' => 'Users.',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function promos()
    {
        try {

            $promos = OrderNumbers::paginate(10);

            return response()->json([

                'success' => true,
                'data'    => $promos,
                'message' => 'Promo Codes.',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function userProfile($id)
    {
        try {
            $user = User::where([
                // ['store_validate', '=', 0],
                ['id', '=', $id],
            ])->first();

            return response()->json([

                'success' => true,
                'data' => $user,
                'message' => 'User Profile Retireved',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function userStatusUpdate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'status' => 'required|boolean|in:0,1', // approved 1 or pending 0
        ]);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        $user = User::find($request->id);
        $user->status = $request->status;
        $user->update();

        return response()->json([

            'success' => true,
            'data' => $user,
            'message' => 'User Status Updated Successfully.',

        ], 200);
    }

    public function dashboardTotals()
    {
        $totals = [
            'totalOrders' => OrderNumbers::count("id"),
            'totalShops' => Shops::count("id"),
            'totalProducts' => Products::count("id"),
            'totalCategories' => Categories::count("id"),
            'totalUsers' => User::count("id"),
            'totalActiveOrders' => OrderNumbers::where("order_status", 1)->count("id"),
        ];

        return response()->json([

            'success' => true,
            'data' => $totals,
            'message' => 'Dashboard Records Retrieved.',

        ], 200);
    }

    public function vendorTransactionHistory(Request $request)
    {

        try {

            // $data = Transactions::where('vendor_id',auth()->user()->id)->paginate($request->per_page ? $request->per_page : 12);
            $data = Transactions::where('vendor_id', $request->vendor_id)->with([
                'user', 'vendor',
                'order' => function ($oq) {

                    return $oq->whereHas('transaction', function ($oqt) {
                        return $oqt->where('source_type', 'order');
                    });
                },
                'purchasePackages' => function ($qp) {
                    return $qp->whereHas('transaction', function ($pt) {
                        return $pt->where('source_type', 'package');
                    });
                }, 'purchasePackages.package'
            ])
                ->orderBy('id', 'desc')
                ->paginate($request->per_page ? $request->per_page : 12);

            $data_collect = $data->toArray();

            $total_earning_order = Transactions::where('vendor_id', $request->vendor_id)->where('source_type', 'order')->sum('amount');
            $total_package_invest = Transactions::where('vendor_id', $request->vendor_id)->where('source_type', 'package')->sum('amount');
            $total_earning_order_payment = Transactions::where('vendor_id', $request->vendor_id)->where(['source_type' => 'order', 'type' => 'deposit'])->sum('amount');
            $total_earning_order_cash = Transactions::where('vendor_id', $request->vendor_id)->where(['source_type' => 'order', 'type' => 'cash'])->sum('amount');


            $userData = User::find($request->vendor_id);

            
            $data_collect['user_balance']  = $userData->balance_amount;
            $data_collect['total_earning_order'] = $total_earning_order;
            $data_collect['total_earning_order_payment'] = $total_earning_order_payment;
            $data_collect['total_earning_order_cash'] = $total_earning_order_cash;
            $data_collect['total_package_invest'] = $total_package_invest;

            // $data['data']['asdasdad'] = 10000000000000;

            return response()->json([
                'status'  => true,
                'data'    => $data_collect,
                'message' => 'Product Search Successfully'
            ], 200);
        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
    }











    public function adminTransactionHistory(Request $request)
    {

        try {

            // $data = Transactions::where('vendor_id',auth()->user()->id)->paginate($request->per_page ? $request->per_page : 12);
            $data = Transactions::with([
                'user', 'vendor',
                'order' => function ($oq) {

                    return $oq->whereHas('transaction', function ($oqt) {
                        return $oqt->where('source_type', 'order');
                    });
                },
                'purchasePackages' => function ($qp) {
                    return $qp->whereHas('transaction', function ($pt) {
                        return $pt->where('source_type', 'package');
                    });
                }, 'purchasePackages.package'
            ])
                ->orderBy('id', 'desc')
                ->paginate($request->per_page ? $request->per_page : 12);

            $data_collect = $data->toArray();

            $total_earning_order = Transactions::where('source_type', 'order')->sum('amount');
            // $total_package_invest = Transactions::where('vendor_id', $request->vendor_id)->where('source_type', 'package')->sum('amount');
            $total_earning_order_payment = Transactions::where(['source_type' => 'order', 'type' => 'deposit'])->sum('amount');
            $total_earning_order_cash = Transactions::where(['source_type' => 'order', 'type' => 'cash'])->sum('amount');


            $userData = User::find($request->vendor_id);

            
            // $data_collect['user_balance']  = $userData->balance_amount;
            $data_collect['total_earning_order'] = $total_earning_order;
            $data_collect['total_earning_order_payment'] = $total_earning_order_payment;
            $data_collect['total_earning_order_cash'] = $total_earning_order_cash;
            // $data_collect['total_package_invest'] = $total_package_invest;

            // $data['data']['asdasdad'] = 10000000000000;

            return response()->json([
                'status'  => true,
                'data'    => $data_collect,
                'message' => 'Product Search Successfully'
            ], 200);
        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
    }



    public function vendorTransactionHistoryView(Request $request)
    {

        try {

            // $data = Transactions::where('vendor_id',auth()->user()->id)->paginate($request->per_page ? $request->per_page : 12);
            $data = Transactions::where(['id' => $request->id])->with([
                'user', 'vendor',
                'order' => function ($oq) {

                    return $oq->whereHas('transaction', function ($oqt) {
                        return $oqt->where('source_type', 'order');
                    });
                },
                'purchasePackages' => function ($qp) {
                    return $qp->whereHas('transaction', function ($pt) {
                        return $pt->where('source_type', 'package');
                    });
                }, 'purchasePackages.product', 'purchasePackages.package'
            ])
                ->orderBy('id', 'desc')
                ->first();

            return response()->json([
                'status'  => true,
                'data'    => $data,
                'message' => 'Product Search Successfully'
            ], 200);
        } catch (Exception $e) {

            return response()->json([
                'status'  => false,
                'data'    => $e->getMessage(),
                'message' => 'error occurred'
            ], 500);
        }
    }

}
