<?php

namespace App\Http\Controllers;

use App\Models\Categories;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class AdminCategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $query = Categories::where('id_parent', 0)->orderBy('id', 'desc');

        if(!empty($request->title)){
            $query->where("name", "like", "%{$request->title}%");
        }

        $categories = $query->paginate(1000);

        return response()->json([

            'success' => true,
            'data' => $categories,
            'message' => 'All Main Categories.',

        ], 200);
    }

    public function parentCategory()
    {
        //
        $parentCategory = Categories::where('id_parent', 0)->get();

        return response()->json([

            'success' => true,
            'data' => $parentCategory,
            'message' => 'All Parent Categories retrieved',

        ], 200);
    }

    public function getCategory($id)
    {
        try {
            $category = Categories::where('id', $id)->first();

            return response()->json([

                'success' => true,
                'data' => $category,
                'message' => 'Single Main Category',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $validator = Validator::make($request->all(), [

            'name' => 'required|string|max:25',
            'description' => 'required|string|max:255',
            'image' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        try {
            $category = new Categories();
            $category->name = $request->name;
            $category->description = $request->description;
            $category->status = 1;
            $category->id_parent = 0;

            if ($request->hasFile('image')) {
                $filename = time() . '.' . request()->image->getClientOriginalExtension();
                $request->image->move(public_path('uploads'), $filename);
                $category->image = '/uploads/' . $filename;
            }
            $category->save();

            return response()->json([

                'success' => true,
                'data' => $category,
                'message' => 'Main Category Added Successfully.',

            ], 200);
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    /**
     * Store a newly created sub-resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeSubCategory(Request $request)
    {
        //
        $validator = Validator::make($request->all(), [

            'name' => 'required|string|max:25',
            'description' => 'required|string|max:255',
            'image' => 'required',
            'category' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        try {
            $category = new Categories();
            $category->name = $request->name;
            $category->description = $request->description;
            $category->status = 1;
            $category->id_parent = $request->category;

            if ($request->hasFile('image')) {
                $filename = time() . '.' . request()->image->getClientOriginalExtension();
                $request->image->move(public_path('uploads'), $filename);
                $category->image = '/uploads/' . $filename;
            }
            $category->save();

            return response()->json([

                'success' => true,
                'data' => $category,
                'message' => 'Sub-Category Added Successfully.',

            ], 200);
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function getSubCategories(Request $request)
    {
        //
        $query = Categories::where('id_parent', '>', 0)
        ->with("parentMember")
        ->orderBy('id', 'desc');;

            if(!empty($request->title)){
                $query->where("name", "like", "%{$request->title}%");
            }

            $categories = $query->paginate(10);

        return response()->json([

            'success' => true,
            'data' => $categories,
            'message' => 'All Sub-Categories.',

        ], 200);
    }

    public function getSingleSubCategory($id)
    {
        try {
            $category = Categories::where('id', $id)->first();

            return response()->json([

                'success' => true,
                'data' => $category,
                'message' => 'Single Sub Category',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $validator = Validator::make($request->all(), [

            'name' => 'required|string|max:25',
            'description' => 'required|string|max:255',
            // 'image' => 'required',
            // 'status' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        try {
            $category = Categories::find($id);

            $category->name = $request->name;
            $category->description = $request->description;
            // $category->status = 1;

            if ($request->hasFile('image')) {
                $filename = time() . '.' . request()->image->getClientOriginalExtension();
                $request->image->move(public_path('uploads'), $filename);
                $category->image = '/uploads/' . $filename;
            }
            $category->update();

            return response()->json([

                'success' => true,
                'data' => $category,
                'message' => 'Category Updated Successfully.',

            ], 200);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function updateSubCategory(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [

            'name' => 'required|string|max:25',
            'description' => 'required|string|max:255',
            // 'image' => 'required',
            'category' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        $subCategory = Categories::find($id);
        $subCategory->name = $request->name;
        $subCategory->description = $request->description;
        $subCategory->id_parent = $request->category;

        if ($request->hasFile('image')) {
            $filename = time() . '.' . request()->image->getClientOriginalExtension();
            $request->image->move(public_path('uploads'), $filename);
            $subCategory->image = '/uploads/' . $filename;
        }

        $subCategory->update();

        return response()->json([

            'success' => true,
            'data' => $subCategory,
            'message' => 'Sub-Category Updated Successfully.',

        ], 200);

        try {
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function categoryStatusUpdate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'status' => 'required|boolean|in:0,1', // approved 1 or pending 0
        ]);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        $category = Categories::find($request->id);
        $category->status = $request->status;
        $category->update();

        $subCategory = Categories::where("id_parent",$category->id)->get()->pluck('id')->toArray();
        $subCategoryUpdate = Categories::whereIn("id",$subCategory)->update(['status' => $request->status]);

        return response()->json([

            'success' => true,
            'data' => $category,
            'message' => 'Category Status Updated Successfully.',

        ], 200);
    }

    public function subCategoryStatusUpdate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'status' => 'required|boolean|in:0,1', // approved 1 or pending 0
        ]);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        $category = Categories::find($request->id);
        $category->status = $request->status;
        $category->update();

        return response()->json([

            'success' => true,
            'data' => $category,
            'message' => 'Category Status Updated Successfully.',

        ], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
