<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\{
    Address
};
use Illuminate\Support\Facades\Auth;

class AddressController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            

            $address = Address::where(['id_user' => Auth::user()->id])->get();
            return response()->json([

                'success' => true,
                'message' => 'Address loaded successfully.',
                'data' => $address,

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }

        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $validatorArr = [

            'firstname'   => 'required',
            'lastname'    => 'required',
            'email'       => 'required',
            'phone'       => 'required',
            'address'     => 'required',
            'city'        => 'required',
            'code'        => 'required',
            'country'     => 'required',
        ];

        $validator = Validator::make($request->all(),$validatorArr);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        try {
            

            $address = Address::create([
                'firstname'   => $request->firstname,
                'lastname'    => $request->lastname,
                'email'       => $request->email,
                'phone'       => $request->phone,
                'address'     => $request->address,
                'city'        => $request->city,
                'code'        => $request->code,
                'country'     => $request->country,
                'id_user'     => Auth::user()->id
            ]);

            return response()->json([

                'success' => true,
                'message' => 'Address created successfully.',
                'data' => $address,

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        
        //
    }


    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {

        try {
            

            $address = Address::find($request->id);

            return response()->json([

                'success' => true,
                'message' => 'Address retrive successfully.',
                'data' => $address,

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }

        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatorArr = [

            'firstname'   => 'required',
            'lastname'    => 'required',
            'email'       => 'required',
            'phone'       => 'required',
            'address'     => 'required',
            'city'        => 'required',
            'code'        => 'required',
            'country'     => 'required',
        ];

        $validator = Validator::make($request->all(),$validatorArr);

        if ($validator->fails()) {

            return response()->json([

                'success' => false,
                'data' => $validator->errors()

            ], 422);
        }

        try {
            

            $address = Address::where(['id' => $id , 'id_user' => Auth::user()->id])->first();
            
            $address->update([
                'firstname'   => $request->firstname,
                'lastname'    => $request->lastname,
                'email'       => $request->email,
                'phone'       => $request->phone,
                'address'     => $request->address,
                'city'        => $request->city,
                'code'        => $request->code,
                'country'     => $request->country
            ]);

            return response()->json([

                'success' => true,
                'message' => 'Address updated successfully.',
                'data' => $address,

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        try {
            

            $address = Address::where(['id' => $id , 'id_user' => Auth::user()->id])->first();
            $address->delete();
            return response()->json([

                'success' => true,
                'message' => 'Address deleted successfully.',
                'data' => $address,

            ], 200);

            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }


       

        //
    }
}
