<!DOCTYPE html>
<html lang="en">
	<!--begin::Head-->
	<head>
		<title>Gologonow Lead Management | Leads</title>
		<?php echo $__env->make('global.header-links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!--end::Global Stylesheets Bundle-->
	</head>
    <!--end::Head-->
	<!--begin::Body-->
	<body id="kt_body" class="header-fixed header-tablet-and-mobile-fixed toolbar-enabled toolbar-fixed aside-enabled aside-fixed" style="--kt-toolbar-height:55px;--kt-toolbar-height-tablet-and-mobile:55px">
		<!--begin::Main-->
		<!--begin::Root-->
		<div class="d-flex flex-column flex-root">
			<!--begin::Page-->
			<div class="page d-flex flex-row flex-column-fluid">
				<!--begin::Aside-->
				<?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				<!--end::Aside-->
				<!--begin::Wrapper-->
				<div class="wrapper d-flex flex-column flex-row-fluid" id="kt_wrapper">
					<!--begin::Header-->
					<?php echo $__env->make('partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					<!--end::Header-->
					<!--begin::Content-->
					<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
						<!--begin::Toolbar-->
						<div class="toolbar" id="kt_toolbar">
							<!--begin::Container-->
							<div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
								<!--begin::Page title-->
								<div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
									<!--begin::Title-->
									<h1 class="d-flex text-dark fw-bolder fs-3 align-items-center my-1">Leads</h1>
									<!--end::Title-->
								</div>
								<!--end::Page title-->
							</div>
							<!--end::Container-->
						</div>
						<!--end::Toolbar-->
						
                        <!-- EXERCISE EQUIPMENTS -->
                        <div class="post d-flex flex-column-fluid" id="kt_post">
							<!--begin::Container-->
							<div id="kt_content_container" class="container-xxl">
								<!--begin::Category-->
								<div class="card card-flush">
									<!--begin::Card header-->
									<div class="card-header align-items-center py-5 gap-2 gap-md-5">
										<!--begin::Card title-->
										<div class="card-title">
											<!--begin::Search-->
											<div class="d-flex align-items-center position-relative my-1">
												<!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
												<span class="svg-icon svg-icon-1 position-absolute ms-4">
													<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
														<rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1" transform="rotate(45 17.0365 15.1223)" fill="currentColor" />
														<path d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z" fill="currentColor" />
													</svg>
												</span>
												<!--end::Svg Icon-->
												<input type="text" data-kt-ecommerce-category-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Search Lead" />
											</div>
											<!--end::Search-->
										</div>
										<!--end::Card title-->
										<!--begin::Card toolbar-->
										<div class="card-toolbar">
											<button type="button" class="btn btn-light-primary btn-sm" data-bs-toggle="modal" data-bs-target="#kt_modal_add_schedule">
												Add New Lead
											</button>
										</div>
										<!--end::Card toolbar-->
									</div>
									<!--end::Card header-->
									<!--begin::Card body-->
									<div class="card-body pt-0">
										<?php if($errors->any()): ?>
											<div class="alert alert-danger">
												<ul class="error-list">
													<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<li><?php echo e($error); ?></li>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</ul>
											</div>
										<?php endif; ?>
										<!--begin::Table-->
										<table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_ecommerce_category_table">
											<!--begin::Table head-->
											<thead>
												<!--begin::Table row-->
												<tr class="text-start text-gray-400 fw-bolder fs-7 text-uppercase gs-0">
													<th class="w-10px pe-2">
														<div class="form-check form-check-sm form-check-custom form-check-solid me-3">
															<input class="form-check-input" type="checkbox" data-kt-check="true" data-kt-check-target="#kt_ecommerce_category_table .form-check-input" value="1" />
														</div>
													</th>
													<th class="min-w-100px">Client Name</th>
													<th class="min-w-100px">Business Name</th>
													<th class="min-w-100px">Email</th>
													<th class="min-w-100px">Cell Phone</th>
													<th class="min-w-100px">Location</th>
													<th class="min-w-100px">Agent</th>
													<th class="min-w-100px">Status</th>
													<th class="text-end min-w-70px">Actions</th>
												</tr>
												<!--end::Table row-->
											</thead>
											<!--end::Table head-->
											<!--begin::Table body-->
											<tbody class="fw-bold text-gray-600">
												<!--begin::Table row-->
												<?php $__currentLoopData = $client; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<!--begin::Checkbox-->
													<td>
														<div class="form-check form-check-sm form-check-custom form-check-solid">
															<input class="form-check-input" type="checkbox" value="1" />
														</div>
													</td>
													<!--end::Checkbox-->
													<!--begin::Category=-->
													<td>
														<div class="d-flex">
															<div class="ms-5">
																<!--begin::Title-->
																<a href="/admin/lead/<?php echo e($item->id); ?>" class="text-gray-800 text-hover-primary fs-5 fw-bolder mb-1" data-kt-ecommerce-category-filter="category_name"><?php echo e(ucfirst($item->name)); ?></a>
																<!--end::Title-->
															</div>
														</div>
													</td>
													<!--end::Category=-->
													<td>
														<?php echo e(ucfirst($item->business_name)); ?>

													</td>
													<td>
														<?php echo e($item->email); ?>

													</td>
													<td>
														<?php echo e($item->cell_phone); ?>

													</td>
													<td>
														<?php echo e($item->location); ?>

													</td>
													<td>
														<?php echo e(ucfirst($item->agent->username)); ?>

													</td>
													<!--begin::Type=-->
													<td>
														<!--begin::Badges-->
														<div class="badge badge-light-success">
															<?php echo e($item->status->name); ?>

														</div> 
														<!--end::Badges-->
													</td>
													<!--end::Type=-->
													<!--begin::Action=-->
													<td class="text-end">
														<a href="#" class="btn btn-sm btn-light btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions
														<!--begin::Svg Icon | path: icons/duotune/arrows/arr072.svg-->
														<span class="svg-icon svg-icon-5 m-0">
															<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
																<path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="currentColor" />
															</svg>
														</span>
														<!--end::Svg Icon--></a>
														<!--begin::Menu-->
														<div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-bold fs-7 w-150px py-4" data-kt-menu="true">
															<!--begin::Menu item-->
															<div class="menu-item px-3">
																<a class="menu-link px-3 cls-link-convert" data-id="<?php echo e($item->id); ?>" data-status_id="2" data-status="Voice Mail" data-bs-toggle="modal" data-bs-target="#kt_modal_project_status">Voice Mail</a>
															</div>
															<div class="menu-item px-3">
																<a class="menu-link px-3 cls-link-convert" data-id="<?php echo e($item->id); ?>" data-status_id="3" data-status="Not Interested" data-bs-toggle="modal" data-bs-target="#kt_modal_project_status">Not Interested</a>
															</div>
															<div class="menu-item px-3">
																<a class="menu-link px-3 cls-link-convert" data-id="<?php echo e($item->id); ?>" data-status_id="4" data-status="Call Back" data-bs-toggle="modal" data-bs-target="#kt_modal_project_status">Call Back</a>
															</div>
															<div class="menu-item px-3">
																<a class="menu-link px-3 cls-link-convert" data-id="<?php echo e($item->id); ?>" data-status_id="5" data-status="Found Someone Else" data-bs-toggle="modal" data-bs-target="#kt_modal_project_status">Found Someone Else</a>
															</div>
															<div class="menu-item px-3">
																<a class="menu-link px-3 cls-link-convert" data-id="<?php echo e($item->id); ?>" data-status_id="6" data-status="No Answer" data-bs-toggle="modal" data-bs-target="#kt_modal_project_status">No Answer</a>
															</div>
															<div class="menu-item px-3">
																<a class="menu-link px-3 cls-link-convert" data-id="<?php echo e($item->id); ?>" data-status_id="7" data-status="Convert" data-bs-toggle="modal" data-bs-target="#kt_modal_project">Convert</a>
															</div>
															<div class="menu-item px-3">
																<a class="menu-link px-3 cls-link-convert" data-id="<?php echo e($item->id); ?>" data-status_id="8" data-status="Discovery" data-bs-toggle="modal" data-bs-target="#kt_modal_project_status">Discovery</a>
															</div>
															<div class="menu-item px-3">
																<a class="menu-link px-3 cls-link-convert" data-id="<?php echo e($item->id); ?>" data-status_id="9" data-status="Documentation" data-bs-toggle="modal" data-bs-target="#kt_modal_project_status">Documentation</a>
															</div>
															<div class="menu-item px-3">
																<a href="#" class="menu-link px-3">Edit</a>
															</div>
															<!--end::Menu item-->
														</div>
														<!--end::Menu-->
													</td>
													<!--end::Action=-->
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<!--end::Table row-->
											</tbody>
											<!--end::Table body-->
										</table>
										<!--end::Table-->
									</div>
									<!--end::Card body-->
								</div>
								<!--end::Category-->
								<!--begin::Modal - Add schedule-->
								<div class="modal fade" id="kt_modal_add_schedule" tabindex="-1" aria-hidden="true">
									<!--begin::Modal dialog-->
									<div class="modal-dialog modal-dialog-centered mw-650px">
										<!--begin::Modal content-->
										<div class="modal-content">
											<!--begin::Modal header-->
											<div class="modal-header">
												<!--begin::Modal title-->
												<h2 class="fw-bolder">Add new Lead</h2>
												<!--end::Modal title-->
												<!--begin::Close-->
												<div class="btn btn-icon btn-sm btn-active-icon-primary" data-bs-dismiss="modal">
													<!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
													<span class="svg-icon svg-icon-1">
														<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
															<rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
															<rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor" />
														</svg>
													</span>
													<!--end::Svg Icon-->
												</div>
												<!--end::Close-->
											</div>
											<!--end::Modal header-->
											<!--begin::Modal body-->
											
											<div class="modal-body scroll-y mx-5 mx-xl-15 my-7">
												<!--begin::Form-->
												<form id="kt_modal_add_schedule_form" class="form" action="<?php echo e(route('admin.store-lead')); ?>" method="POST" enctype="multipart/form-data">
													<?php echo csrf_field(); ?>
													<!--begin::Input group-->
													<input type="hidden" value="" name="workoutplan-id" />
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Client Name</label>
														<!--end::Label-->
														<!--begin::Input-->
														<input type="text" class="form-control form-control-solid" name="client-name" placeholder="Full Name" required/>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Business Name</label>
														<!--end::Label-->
														<!--begin::Input-->
														<input type="text" class="form-control form-control-solid" name="business-name" placeholder="Business Name" required/>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Email Address</label>
														<!--end::Label-->
														<!--begin::Input-->
														<input type="email" class="form-control form-control-solid" name="client-email" placeholder="Email Address" required/>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Cell Phone</label>
														<!--end::Label-->
														<!--begin::Input-->
														<input type="text" class="form-control form-control-solid" name="client-cellphone" placeholder="Cell Phone" required/>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Cell Phone Alternate</label>
														<!--end::Label-->
														<!--begin::Input-->
														<input type="text" class="form-control form-control-solid" name="client-cellphone-alt" placeholder="Cell Phone Alternate" required/>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Address Lcoation</label>
														<!--end::Label-->
														<!--begin::Input-->
														<input type="text" class="form-control form-control-solid" name="client-location" placeholder="Address Location" required/>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Lead Date</label>
														<!--end::Label-->
														<!--begin::Input-->
														<input class="form-control form-control-solid" placeholder="Lead Date" id="kt_datepicker_1" name="onboard-date" required/>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fw-bold fs-6 mb-2">Select Account</label>
														<!--end::Label-->
														<!--begin::Input-->
														<select class="form-select form-select-solid fw-bolder" data-kt-select2="true" data-placeholder="Select payment platform" data-allow-clear="true" data-hide-search="true" name="account_id">
															<?php $__currentLoopData = $account; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<option value="<?php echo e($acc->id); ?>">
																	<?php echo e(ucfirst($acc->title)); ?>

																</option>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</select>
														<!--end::Input-->
													</div>
													<?php if(auth()->user()->roles[0]->name == 'admin'): ?>
														<div class="fv-row mb-7">
															<!--begin::Label-->
															<label class="required fw-bold fs-6 mb-2">Agent</label>
															<select name="agent-id" aria-label="Select a Agent" data-control="select2" data-hide-search="true" data-placeholder="Select a agent..." class="form-select form-select-solid form-select-lg" required >
																<option value="">Select a Agent...</option>
																<?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																	<option value="<?php echo e($item->id); ?>"><?php echo e(ucfirst($item->username)); ?></option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
														</div>
													<?php else: ?>
														<input type="hidden" value="<?php echo e(auth()->user()->id); ?>" name="agent-id" />
													<?php endif; ?>
													<!--end::Input group-->
													<!--begin::Actions-->
													<div class="text-center pt-15">
														<button type="reset" class="btn btn-light me-3" data-kt-users-modal-action="cancel">Discard</button>
														<button type="submit" class="btn btn-primary">
															<span class="indicator-label">Submit</span>
															<span class="indicator-progress">Please wait...
															<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
														</button>
													</div>
													<!--end::Actions-->
												</form>
												<!--end::Form-->
											</div>
											<!--end::Modal body-->
										</div>
										<!--end::Modal content-->
									</div>
									<!--end::Modal dialog-->
								</div>

								<div class="modal fade" id="kt_modal_project" tabindex="-1" aria-hidden="true">
									<!--begin::Modal dialog-->
									<div class="modal-dialog modal-dialog-centered mw-650px">
										<!--begin::Modal content-->
										<div class="modal-content">
											<!--begin::Modal header-->
											<div class="modal-header">
												<!--begin::Modal title-->
												<h2 class="fw-bolder">Convert Lead</h2>
												<!--end::Modal title-->
												<!--begin::Close-->
												<div class="btn btn-icon btn-sm btn-active-icon-primary" data-bs-dismiss="modal">
													<!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
													<span class="svg-icon svg-icon-1">
														<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
															<rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
															<rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor" />
														</svg>
													</span>
													<!--end::Svg Icon-->
												</div>
												<!--end::Close-->
											</div>
											<!--end::Modal header-->
											<!--begin::Modal body-->
											<div class="modal-body scroll-y mx-5 mx-xl-15 my-7">
												<!--begin::Form-->
												<form id="kt_modal_add_schedule_form" class="form" action="<?php echo e(route('admin.lead-converted')); ?>" method="POST" enctype="multipart/form-data">
													<?php echo csrf_field(); ?>
													<input type="hidden" name="client_id" class="lead-id" />
													<input type="hidden" name="lead_status" class="lead-status" />
													<!--begin::Input group-->
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Project Title</label>
														<!--end::Label-->
														<!--begin::Input-->
														<input type="text" class="form-control form-control-solid" name="project-title" placeholder="Project Title" required/>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7" id="project-description">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Description</label>
														<!--end::Label-->
														<!--begin::Input-->
														<textarea id="kt_docs_tinymce_basic" name="kt_docs_tinymce_basic" class="tox-target"></textarea>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Total Cost</label>
														<!--end::Label-->
														<!--begin::Input-->
														<div class="input-group mb-5">
															<span class="input-group-text">$</span>
															<input type="text" class="form-control form-control-solid" name="project-budget" placeholder="Project Cost" required/>
															<span class="input-group-text">.00</span>
														</div>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fs-6 fw-bold form-label mb-2">Amount Charge</label>
														<!--end::Label-->
														<!--begin::Input-->
														<div class="input-group mb-5">
															<span class="input-group-text">$</span>
															<input type="text" class="form-control form-control-solid" name="amount-charge" placeholder="Amount Charge" required/>
															<span class="input-group-text">.00</span>
														</div>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fw-bold fs-6 mb-2">Select Currency</label>
														<!--end::Label-->
														<!--begin::Input-->
														<select class="form-select form-select-solid fw-bolder" data-kt-select2="true" data-placeholder="Select payment platform" data-allow-clear="true" data-hide-search="true"  name="currency">
															<option value="">Select a Currency...</option>
															<option value="$">
																Dollar ($)
															</option>
															<option value="€">
																Euro (€)
															</option>
															<option value="£">
																Pound Sterling (£)
															</option>
															<option value="د.ك">
																Dinar (د.ك)
															</option>
															<option value="د.إ">
																Dirham (د.إ)
															</option>
														</select>
														<!--end::Input-->
													</div>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="required fw-bold fs-6 mb-2">Payment Through</label>
														<!--end::Label-->
														<!--begin::Input-->
														<select class="form-select form-select-solid fw-bolder" data-kt-select2="true" data-placeholder="Select payment platform" data-allow-clear="true" data-hide-search="true"  name="payment-through">
															<option value="">Payment Through...</option>
															<option value="Authorize.net">Authorize.net</option> 
															<option value="Stripe">Stripe</option> 
															<option value="Zelle">Zelle</option> 
															<option value="Interac e-transfer">Interac e-transfer</option> 
															<option value="Wire transfer">Wire transfer</option> 
														</select>
														<!--end::Input-->
													</div>
													<?php if(auth()->user()->roles[0]->name == 'admin'): ?>
														<div class="fv-row mb-7">
															<!--begin::Label-->
															<label class="required fw-bold fs-6 mb-2">Agent</label>
															<select name="agent_id" aria-label="Select a Agent" data-control="select2" data-hide-search="true" data-placeholder="Select a agent..." class="form-select form-select-solid form-select-lg" required >
																<option value="">Select a Agent...</option>
																<?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																	<option value="<?php echo e($item->id); ?>"><?php echo e(ucfirst($item->username)); ?></option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
														</div>
													<?php else: ?>
														<input type="hidden" value="<?php echo e(auth()->user()->id); ?>" name="agent_id" />
													<?php endif; ?>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="fw-bold fs-6 mb-2">Comments</label>
														<!--end::Label-->
														<!--begin::Input-->
														<textarea name="comments" rows="5" class="form-control form-control-solid mb-3 mb-lg-0"></textarea>
														<!--end::Input-->
													</div>
													<!--end::Input group-->
													<!--begin::Actions-->
													<div class="text-center pt-15">
														<button type="reset" class="btn btn-light me-3" data-kt-users-modal-action="cancel">Discard</button>
														<button type="submit" class="btn btn-primary">
															<span class="indicator-label">Convert</span>
															<span class="indicator-progress">Please wait...
															<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
														</button>
													</div>
													<!--end::Actions-->
												</form>
												<!--end::Form-->
											</div>
											<!--end::Modal body-->
										</div>
										<!--end::Modal content-->
									</div>
									<!--end::Modal dialog-->
								</div>

								<div class="modal fade" id="kt_modal_project_status" tabindex="-1" aria-hidden="true">
									<!--begin::Modal dialog-->
									<div class="modal-dialog modal-dialog-centered mw-650px">
										<!--begin::Modal content-->
										<div class="modal-content">
											<!--begin::Modal header-->
											<div class="modal-header">
												<!--begin::Modal title-->
												<h2 class="fw-bolder">Change Lead Status to <span class="lead_status_heading"></span></h2>
												<!--end::Modal title-->
												<!--begin::Close-->
												<div class="btn btn-icon btn-sm btn-active-icon-primary" data-bs-dismiss="modal">
													<!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
													<span class="svg-icon svg-icon-1">
														<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
															<rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
															<rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor" />
														</svg>
													</span>
													<!--end::Svg Icon-->
												</div>
												<!--end::Close-->
											</div>
											<!--end::Modal header-->
											<!--begin::Modal body-->
											<div class="modal-body scroll-y mx-5 mx-xl-15 my-7">
												<!--begin::Form-->
												<form id="kt_modal_add_schedule_form" class="form" action="<?php echo e(route('admin.lead-status')); ?>" method="POST" enctype="multipart/form-data">
													<?php echo csrf_field(); ?>
													<input type="hidden" name="client_id" class="lead-id" />
													<input type="hidden" name="lead_status" class="lead-status" />
													<!--begin::Input group-->
													<?php if(auth()->user()->roles[0]->name == 'admin'): ?>
														<div class="fv-row mb-7">
															<!--begin::Label-->
															<label class="required fw-bold fs-6 mb-2">Agent</label>
															<select name="agent_id" aria-label="Select a Agent" data-control="select2" data-hide-search="true" data-placeholder="Select a agent..." class="form-select form-select-solid form-select-lg" required >
																<option value="">Select a Agent...</option>
																<?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																	<option value="<?php echo e($item->id); ?>"><?php echo e(ucfirst($item->username)); ?></option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
														</div>
													<?php else: ?>
														<input type="hidden" value="<?php echo e(auth()->user()->id); ?>" name="agent_id" />
													<?php endif; ?>
													<div class="fv-row mb-7">
														<!--begin::Label-->
														<label class="fw-bold fs-6 mb-2">Comments</label>
														<!--end::Label-->
														<!--begin::Input-->
														<textarea name="comments" rows="5" class="form-control form-control-solid mb-3 mb-lg-0"></textarea>
														<!--end::Input-->
													</div>
													<!--end::Input group-->
													<!--begin::Actions-->
													<div class="text-center pt-15">
														<button type="reset" class="btn btn-light me-3" data-kt-users-modal-action="cancel">Discard</button>
														<button type="submit" class="btn btn-primary">
															<span class="indicator-label">Convert</span>
															<span class="indicator-progress">Please wait...
															<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
														</button>
													</div>
													<!--end::Actions-->
												</form>
												<!--end::Form-->
											</div>
											<!--end::Modal body-->
										</div>
										<!--end::Modal content-->
									</div>
									<!--end::Modal dialog-->
								</div>
								<!--end::Modal - Add schedule-->
							</div>
							<!--end::Container-->
						</div>
                    </div>
					<!--begin::Footer-->
					<?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					<!--end::Footer-->
                </div>
            </div>
        </div>
        <?php echo $__env->make('global.footer-links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </body>
</html><?php /**PATH /home/gologonowapp/public_html/glnleads/resources/views/admin/lead/index.blade.php ENDPATH**/ ?>