<?php

use App\Http\Controllers\LayoutController;
use App\Http\Controllers\OperationController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('index');
});

Route::get('/login', [LayoutController::class, 'login'])->name('login');
Route::get('/register', [LayoutController::class, 'register'])->name('register');

Route::post('/authenticate', [OperationController::class, 'authenticate']);
Route::post('/create-account', [OperationController::class, 'createAccount']);

Route::post('/logout', [OperationController::class, 'logout'])->name('logout');

Route::prefix('admin')->name('admin.')->group(function () {
    
    Route::middleware(['auth','role:admin'])->group(function () { 

        Route::get('/departments', [LayoutController::class, 'department'])->name('departments');
        Route::post('/store-department', [OperationController::class, 'storeDepartment'])->name('store-department');
        Route::get('/department-status-change/{id}', [OperationController::class, 'departmentStatus'])->name('department-status-change');

        Route::get('/accounts', [LayoutController::class, 'account'])->name('accounts');
        Route::post('/store-account', [OperationController::class, 'storeAccount'])->name('store-account');
        Route::get('/account-status-change/{id}', [OperationController::class, 'accountStatus'])->name('account-status-change');
        
        Route::get('/leads', [LayoutController::class, 'lead'])->name('leads');
        Route::post('/store-lead', [OperationController::class, 'storeLead'])->name('store-lead');    
        Route::post('/lead-converted', [OperationController::class, 'leadConverted'])->name('lead-converted');    
        Route::post('/lead-status', [OperationController::class, 'leadStatus'])->name('lead-status');
        Route::get('/lead/{id}', [LayoutController::class, 'leadShow'])->name('lead');    

        Route::get('/projects', [LayoutController::class, 'project'])->name('projects');
        Route::get('/project-delivered/{id}', [LayoutController::class, 'projectDelivered'])->name('project-delivered');
        Route::get('/projects-delivered', [LayoutController::class, 'completeProject'])->name('projects-delivered');
        Route::get('/project-revert/{id}', [LayoutController::class, 'projectRevert'])->name('project-revert');
        Route::get('/project-amount-charge', [LayoutController::class, 'projectCosting'])->name('project-amount-charge');
        
        Route::get('/agents', [LayoutController::class, 'agent'])->name('agents');
        Route::get('/agent-target', [LayoutController::class, 'agentTarget'])->name('agent-target');

        
        
        
        Route::post('/store-project', [OperationController::class, 'storeProject'])->name('store-project');
        Route::post('/store-project-costing', [OperationController::class, 'storeProjectCosting'])->name('store-project-costing');
        Route::post('/store-agent', [OperationController::class, 'storeAgent'])->name('store-agent');
        Route::post('/store-target', [OperationController::class, 'storeTarget'])->name('store-target');

    });

});