<!DOCTYPE html>
<html lang="en">
    <head>
        <title>Gologonow Lead Management | Login</title>
        <meta charset="utf-8" />
        <meta name="description" content="The most advanced Bootstrap Admin Theme on Themeforest trusted by 94,000 beginners and professionals. Multi-demo, Dark Mode, RTL support and complete React, Angular, Vue &amp; Laravel versions. Grab your copy now and get life-time updates for free." />
        <meta name="keywords" content="Metronic, bootstrap, bootstrap 5, Angular, VueJs, React, Laravel, admin themes, web design, figma, web development, free templates, free admin themes, bootstrap theme, bootstrap template, bootstrap dashboard, bootstrap dak mode, bootstrap button, bootstrap datepicker, bootstrap timepicker, fullcalendar, datatables, flaticon" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta property="og:locale" content="en_US" />
        <meta property="og:type" content="article" />
        <meta property="og:title" content="Metronic - Bootstrap 5 HTML, VueJS, React, Angular &amp; Laravel Admin Dashboard Theme" />
        <meta property="og:url" content="https://keenthemes.com/metronic" />
        <meta property="og:site_name" content="Keenthemes | Metronic" />
        <link rel="canonical" href="https://preview.keenthemes.com/metronic8" />
        <link rel="shortcut icon" href="{{asset('assets/media/logos/favicon.ico')}}" />
        
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
        
        <link href="{{asset('assets/plugins/global/plugins.bundle.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{asset('assets/css/style.bundle.css')}}" rel="stylesheet" type="text/css" />
    </head>
    <!--end::Head-->
    <!--begin::Body-->
    <body id="kt_body" class="bg-body">
        <!--begin::Main-->
        <!--begin::Root-->
        <div class="d-flex flex-column flex-root">
            <!--begin::Authentication - Sign-in -->
            <div class="d-flex flex-column flex-lg-row flex-column-fluid">
                <!--begin::Aside-->
                <div class="d-flex flex-column flex-lg-row-auto w-xl-800px positon-xl-relative" style="background-image: url({{asset('assets/media/login/login-aside.jpg')}});background-repeat: no-repeat;background-size: cover;background-position: center">
                    <!--begin::Wrapper-->
                    <div class="d-flex flex-column position-xl-fixed top-0 bottom-0 w-xl-600px scroll-y">
                        <!--begin::Content-->
                        <div class="d-flex flex-row-fluid flex-column text-center p-10 pt-lg-20"></div>
                        <!--end::Content-->
                    </div>
                    <!--end::Wrapper-->
                </div>
                <!--end::Aside-->
                <!--begin::Body-->
                <div class="d-flex flex-column flex-lg-row-fluid py-10">
                    <!--begin::Content-->
                    <div class="d-flex flex-center flex-column flex-column-fluid">
                        <!--begin::Wrapper-->
                        <div class="w-lg-500px p-10 p-lg-15 mx-auto">
                            <!--begin::Form-->
                            <form class="form w-100" novalidate="novalidate" id="kt_sign_up_form" action="/create-account" method="POST" enctype="multipart/form-data">
                                @csrf
								<!--begin::Heading-->
								<div class="mb-10 text-center">
                                    <a href="#" class="py-9 mb-5">
                                        <img alt="Logo" src="{{asset('assets/media/logos/logo.png')}}" class="h-150px" />
                                    </a>
									<!--begin::Title-->
									<h1 class="text-dark mb-3 mt-5">Create an Account</h1>
									<!--end::Title-->
									<!--begin::Link-->
									<div class="text-gray-400 fw-bold fs-4">Already have an account?
									<a href="/login" class="link-warning fw-bolder">Sign in here</a></div>
									<!--end::Link-->
								</div>
								<!--end::Heading-->
                                {{-- @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif --}}
								<!--begin::Input group-->
								<div class="row fv-row mb-10">
									<!--begin::Col-->
                                    <div class="col-xl-12 d-flex justify-content-center">
                                        <!--begin::Image input-->
                                        <div class="image-input image-input-outline" data-kt-image-input="true" style="background-image: url('assets/media/svg/avatars/blank.svg')">
                                            <!--begin::Preview existing avatar-->
                                            <div class="image-input-wrapper w-125px h-125px" style="background-image: url(assets/media/avatars/300-1.jpg)"></div>
                                            <!--end::Preview existing avatar-->
                                            <!--begin::Label-->
                                            <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Change avatar">
                                                <i class="bi bi-pencil-fill fs-7"></i>
                                                <!--begin::Inputs-->
                                                <input type="file" name="avatar" accept=".png, .jpg, .jpeg" required />
                                                <input type="hidden" name="avatar_remove" />
                                                <!--end::Inputs-->
                                            </label>
                                            <!--end::Label-->
                                            <!--begin::Cancel-->
                                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel avatar">
                                                <i class="bi bi-x fs-2"></i>
                                            </span>
                                            <!--end::Cancel-->
                                            <!--begin::Remove-->
                                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove avatar">
                                                <i class="bi bi-x fs-2"></i>
                                            </span>
                                            <!--end::Remove-->
                                        </div>
                                        <!--end::Image input-->
                                        <!--begin::Hint-->
                                        {{-- <div class="form-text">Allowed file types: png, jpg, jpeg.</div> --}}
                                        <!--end::Hint-->
                                    </div>
                                    <!--end::Col-->
								</div>
								<!--end::Input group-->
                                <!--begin::Input group-->
								<div class="row fv-row mb-7">
									<!--begin::Col-->
									<div class="col-xl-6">
										<label class="form-label fw-bolder text-dark fs-6">First Name</label>
										<input class="@error('firstname') is-invalid @enderror form-control form-control-lg form-control-solid" type="text" placeholder="" name="firstname" autocomplete="off" required />
                                        @error('firstname')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
									</div>
									<!--end::Col-->
									<!--begin::Col-->
									<div class="col-xl-6">
										<label class="form-label fw-bolder text-dark fs-6">Last Name</label>
										<input class="@error('lastname') is-invalid @enderror form-control form-control-lg form-control-solid" type="text" placeholder="" name="lastname" autocomplete="off" required />
                                        @error('lastname')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
									</div>
									<!--end::Col-->
								</div>
								<!--end::Input group-->
                                <!--begin::Input group-->
								<div class="row fv-row mb-7">
									<!--begin::Col-->
									<div class="col-xl-6">
										<label class="form-label fw-bolder text-dark fs-6">Age</label>
										<input class="@error('age') is-invalid @enderror form-control form-control-lg form-control-solid" type="number" placeholder="" name="age" autocomplete="off" required />
                                        @error('age')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
									</div>
									<!--end::Col-->
									<!--begin::Col-->
									<div class="col-xl-6">
										<label class="form-label fw-bolder text-dark fs-6">Gender</label>
										<!--begin::Options-->
                                        <div class="d-flex mt-4">
                                            <!--begin::Check-->
                                            <div class="form-check form-check-custom form-check-warning form-check-solid form-check-sm me-7">
                                                <input class="form-check-input" type="radio" checked="checked" value="default" id="kt_builder_page_width_default" name="gender" />
                                                <!--begin::Label-->
                                                <label class="form-check-label text-gray-700 fw-bold text-nowrap" for="kt_builder_page_width_default">Male</label>
                                                <!--end::Label-->
                                            </div>
                                            <!--end::Check-->
                                            <!--begin::Check-->
                                            <div class="form-check form-check-custom form-check-warning form-check-solid form-check-sm me-7">
                                                <input class="form-check-input" type="radio" value="fluid" id="kt_builder_page_width_fluid" name="gender" />
                                                <!--begin::Label-->
                                                <label class="form-check-label text-gray-700 fw-bold text-nowrap" for="kt_builder_page_width_fluid">Female</label>
                                                <!--end::Label-->
                                            </div>
                                            <!--end::Check-->
                                        </div>
                                        <!--end::Options-->
									</div>
									<!--end::Col-->
								</div>
								<!--end::Input group-->
                                <!--begin::Input group-->
								<div class="row fv-row mb-7">
									<!--begin::Col-->
									<div class="col-xl-6">
										<label class="form-label fw-bolder text-dark fs-6">Cell Phone</label>
										<input class="@error('cellphone') is-invalid @enderror form-control form-control-lg form-control-solid" type="text" placeholder="" name="cellphone" autocomplete="off" required />
                                        @error('cellphone')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
									</div>
									<!--end::Col-->
									<!--begin::Col-->
									<div class="col-xl-6">
										<label class="form-label fw-bolder text-dark fs-6">Alternate Cell Phone</label>
										<input class="@error('cellphone-alt') is-invalid @enderror form-control form-control-lg form-control-solid" type="text" placeholder="" name="cellphone-alt" autocomplete="off" required />
                                        @error('cellphone-alt')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
									</div>
									<!--end::Col-->
								</div>
								<!--end::Input group-->
                                <!--begin::Input group-->
								<div class="fv-row mb-7">
									<label class="form-label fw-bolder text-dark fs-6">Department</label>
									<select name="department-id" aria-label="Select a Department" data-control="select2" data-placeholder="Select a department..." class="form-select form-select-solid form-select-lg" required >
                                        <option value="">Select a Department...</option>
                                        @foreach ($department as $item)
                                            @if($item->id == 1 || $item->id == 2)
                                                <option value="{{$item->id}}">{{ucfirst($item->name)}}</option>
                                            @endif
                                        @endforeach
                                    </select>
								</div>
								<!--end::Input group-->
								<!--begin::Input group-->
								<div class="fv-row mb-7">
									<label class="form-label fw-bolder text-dark fs-6">Email</label>
									<input class="@error('email') is-invalid @enderror form-control form-control-lg form-control-solid" type="email" placeholder="" name="email" autocomplete="off" required />
                                    @error('email')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
								</div>
								<!--end::Input group-->
								<!--begin::Input group-->
								<div class="mb-10 fv-row" data-kt-password-meter="true">
									<!--begin::Wrapper-->
									<div class="mb-1">
										<!--begin::Label-->
										<label class="form-label fw-bolder text-dark fs-6">Password</label>
										<!--end::Label-->
										<!--begin::Input wrapper-->
										<div class="position-relative mb-3">
											<input class="@error('password') is-invalid @enderror form-control form-control-lg form-control-solid" type="password" placeholder="" name="password" autocomplete="off" required />
											<span class="btn btn-sm btn-icon position-absolute translate-middle top-50 end-0 me-n2" data-kt-password-meter-control="visibility">
												<i class="bi bi-eye-slash fs-2"></i>
												<i class="bi bi-eye fs-2 d-none"></i>
											</span>
										</div>
										<!--end::Input wrapper-->
										<!--begin::Meter-->
										<div class="d-flex align-items-center mb-3" data-kt-password-meter-control="highlight">
											<div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
											<div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
											<div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
											<div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px"></div>
										</div>
										<!--end::Meter-->
									</div>
									<!--end::Wrapper-->
									<!--begin::Hint-->
									<div class="text-muted">Use 6 or more characters with a mix of letters, numbers &amp; symbols.</div>
									<!--end::Hint-->
								</div>
								<!--end::Input group=-->
								<!--begin::Input group-->
								<div class="fv-row mb-10">
									<label class="form-check form-check-custom form-check-solid form-check-inline">
										<input class="form-check-input" type="checkbox" name="toc" value="1" required />
										<span class="form-check-label fw-bold text-gray-700 fs-6">I Agree
										<a href="#" class="ms-1 link-primary">Terms and conditions</a>.</span>
									</label>
								</div>
								<!--end::Input group-->
								<!--begin::Actions-->
								<div class="text-center">
									<button type="submit" class="btn btn-lg btn-warning w-100 mb-5">Create Account</button>
								</div>
								<!--end::Actions-->
							</form>
                            <!--end::Form-->
                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Content-->
                    <!--begin::Footer-->
                    <!--end::Footer-->
                </div>
                <!--end::Body-->
            </div>
            <!--end::Authentication - Sign-in-->
        </div>
        <!--end::Root-->
        <!--end::Main-->
        <!--begin::Javascript-->
       
        <!--begin::Global Javascript Bundle(used by all pages)-->
        <script src="{{asset('assets/plugins/global/plugins.bundle.js')}}"></script>
        <script src="{{asset('assets/js/scripts.bundle.js')}}"></script>
        <!--end::Global Javascript Bundle-->
        <!--begin::Page Custom Javascript(used by this page)-->
        <script src="{{asset('assets/js/custom/authentication/sign-in/general.js')}}"></script>
        <!--end::Page Custom Javascript-->
        <!--end::Javascript-->
    </body>
    <!--end::Body-->
</html>