<!DOCTYPE html>
<html lang="en">
	<!--begin::Head-->
	<head>
		<title>PDM Fitness | Dasboard</title>
		@include('global.header-links')
		<!--end::Global Stylesheets Bundle-->
	</head>
	<!--end::Head-->
	<!--begin::Body-->
	<body id="kt_body" class="header-fixed header-tablet-and-mobile-fixed toolbar-enabled toolbar-fixed aside-enabled aside-fixed" style="--kt-toolbar-height:55px;--kt-toolbar-height-tablet-and-mobile:55px">
		<!--begin::Main-->
		<!--begin::Root-->
		<div class="d-flex flex-column flex-root">
			<!--begin::Page-->
			<div class="page d-flex flex-row flex-column-fluid">
				<!--begin::Aside-->
				@include('partials.sidebar')
				<!--end::Aside-->
				<!--begin::Wrapper-->
				<div class="wrapper d-flex flex-column flex-row-fluid" id="kt_wrapper">
					<!--begin::Header-->
					@include('partials.header')
					<!--end::Header-->
					<!--begin::Content-->
					<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
						<!--begin::Toolbar-->
						<div class="toolbar" id="kt_toolbar">
							<!--begin::Container-->
							<div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
								<!--begin::Page title-->
								<div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
									<!--begin::Title-->
									<h1 class="d-flex text-dark fw-bolder fs-3 align-items-center my-1">Dashboard</h1>
									<!--end::Title-->
								</div>
								<!--end::Page title-->
							</div>
							<!--end::Container-->
						</div>
						<!--end::Toolbar-->
						<!--begin::Post-->
						<div class="post d-flex flex-column-fluid" id="kt_post">
							<!--begin::Container-->
							<div id="kt_content_container" class="container-xxl">
								<!--begin::Row-->
								<div class="row g-5 g-xl-10 mb-xl-10">
									<div class="col-md-6 col-lg-6 col-xl-6 col-xxl-3 mb-md-5 mb-xl-10">
										<!--begin::Card widget 4-->
										<div class="card card-flush h-md-50 mb-xl-10">
											<!--begin::Header-->
											<div class="card-header pt-5">
												<!--begin::Title-->
												<div class="card-title d-flex flex-column">
													<!--begin::Amount-->
													<span class="fs-2hx fw-bolder text-dark me-2 lh-1 ls-n2">{{count($customers)}} <span class="small-txt">New Customers</span></span>
													<!--end::Amount-->
													<!--begin::Subtitle-->
													<span class="text-gray-400 pt-1 fw-bold fs-6">This Month</span>
													<!--end::Subtitle-->
												</div>
												<!--end::Title-->
											</div>
											<!--end::Header-->
											<!--begin::Card body-->
											<div class="card-body d-flex flex-column justify-content-end pe-0">
												<!--begin::Title-->
												<span class="fs-6 fw-boldest text-gray-800 d-block mb-2">Today’s Heroes</span>
												<!--end::Title-->
												<!--begin::Users group-->
												<div class="symbol-group symbol-hover flex-nowrap">
													@foreach ($customers as $customer)
														<div class="symbol symbol-35px symbol-circle" data-bs-toggle="tooltip" title="{{ucfirst($customer->name)}}">
															<img alt="Pic" src="{{$customer->avatar}}" />
														</div>
													@endforeach

													@if(count($customersAll) > 6)

													<a href="#" class="symbol symbol-35px symbol-circle">
														<span class="symbol-label bg-light text-gray-400 fs-8 fw-bolder">+ {{(count($customersAll)-6)}} </span>
													</a>

													@endif
												</div>
												<!--end::Users group-->
											</div>
											<!--end::Card body-->
										</div>
										<!--end::Card widget 4-->
										<!--begin::Card widget 5-->
										<div class="card card-flush h-md-50 mb-xl-10">
											<!--begin::Header-->
											<div class="card-header pt-5">
												<!--begin::Title-->
												<div class="card-title d-flex flex-column">
													<!--begin::Info-->
													<div class="d-flex align-items-center">
														<!--begin::Amount-->
														<span class="fs-2hx fw-bolder text-dark me-2 lh-1 ls-n2">{{number_format(count($orders))}} <span class="small-txt">Orders</span></span>
														<!--end::Amount-->
													</div>
													<!--end::Info-->
													<!--begin::Subtitle-->
													<span class="text-gray-400 pt-1 fw-bold fs-6">This Month</span>
													<!--end::Subtitle-->
												</div>
												<!--end::Title-->
											</div>
											<!--end::Header-->
											<!--begin::Card body-->
											<div class="card-body d-flex align-items-end pt-0">
												<!--begin::Progress-->
												<div class="d-flex align-items-center flex-column mt-3 w-100">
													<div class="d-flex justify-content-between w-100 mt-auto mb-2">
														<span class="fw-boldest fs-6 text-dark">100 to Goal</span>
														<span class="fw-bolder fs-6 text-gray-400">{{number_format( (count($orders) *100) / 100)}}%</span>
													</div>
													<div class="h-8px mx-3 w-100 bg-light-success rounded">
														<div class="bg-success rounded h-8px" role="progressbar" style="width: {{number_format( (count($orders) *100) / 100)}}%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
													</div>
												</div>
												<!--end::Progress-->
											</div>
											<!--end::Card body-->
										</div>
										<!--end::Card widget 5-->
									</div>
									<!--begin::Col-->
									<div class="col-lg-12 col-xl-12 col-xxl-9 mb-5 mb-xl-0">
										<!--begin::Chart widget 3-->
										<div class="card card-flush overflow-hidden h-md-100">
											<!--begin::Header-->
											<div class="card-header py-5">
												<!--begin::Title-->
												<h3 class="card-title align-items-start flex-column">
													<span class="card-label fw-bolder text-dark">Sales This Months</span>
													<span class="text-gray-400 mt-1 fw-bold fs-6">Users from all products</span>
												</h3>
												<!--end::Title-->
											</div>
											<!--end::Header-->
											<!--begin::Card body-->
											<div class="card-body d-flex justify-content-between flex-column pb-1 px-0">
												<!--begin::Statistics-->
												<div class="px-9 mb-5">
													<!--begin::Statistics-->
													<div class="d-flex mb-2">
														<script>
															var dataTotalAmount = [];
															var dataSaleDate = [];
															var yaxis_max = {{$total_sale}};
															var i = 0
														</script>
														@foreach ($graph_data as $graph)
															<script>
																dataTotalAmount[i] = {{$graph["yaxis_amount"]}};
																dataSaleDate[i] = "{{$graph['xaxis_date']}}";
																i++;
															</script>
														@endforeach
														<script>
															localStorage.setItem('yaxis_max', JSON.stringify(yaxis_max));
															localStorage.setItem('month_sale_data_amount', JSON.stringify(dataTotalAmount));
															localStorage.setItem('month_sale_data_date', JSON.stringify(dataSaleDate));
														</script>
														<span class="fs-4 fw-bold text-gray-400 me-1">$</span>
														<span class="fs-2hx fw-bolder text-gray-800 me-2 lh-1 ls-n2">{{number_format($total_sale)}}</span>
													</div>
													<!--end::Statistics-->
												</div>
												<!--end::Statistics-->
												<!--begin::Chart-->
												<div id="kt_charts_widget_3" class="min-h-auto ps-4 pe-6" style="height: 300px"></div>
												<!--end::Chart-->
											</div>
											<!--end::Card body-->
										</div>
										<!--end::Chart widget 3-->
									</div>
									<!--end::Col-->
								</div>
								<!--end::Row-->
								<!--begin::Row-->
								<div class="row gy-5 g-xl-10">
									<!--begin::Col-->
									<div class="col-xl-12 mb-5 mb-xl-10">
										<!--begin::Table Widget 4-->
										<div class="card card-flush h-xl-100">
											<!--begin::Card header-->
											<div class="card-header pt-7">
												<!--begin::Title-->
												<h3 class="card-title align-items-start flex-column">
													<span class="card-label fw-bolder text-gray-800">Product Stock</span>
												</h3>
												<!--end::Title-->
												<!--begin::Actions-->
												<div class="card-toolbar">
													<!--begin::Filters-->
													<div class="d-flex flex-stack flex-wrap gap-4">
														<!--begin::Status-->
														<div class="d-flex align-items-center fw-bolder">
															<!--begin::Label-->
															<div class="text-gray-400 fs-7 me-2">Status</div>
															<!--end::Label-->
															<!--begin::Select-->
															<select class="form-select form-select-transparent text-dark fs-7 lh-1 fw-bolder py-0 ps-3 w-auto" data-control="select2" data-hide-search="true" data-dropdown-css-class="w-150px" data-placeholder="Select an option" data-kt-table-widget-4="filter_status">
																<option></option>
																<option value="Show All" selected="selected">Show All</option>
																<option value="In Stock">In Stock</option>
																<option value="Low Stock">Low Stock</option>
																<option value="Out of Stock">Out of Stock</option>
															</select>
															<!--end::Select-->
														</div>
														<!--end::Status-->
														<!--begin::Search-->
														<div class="position-relative my-1">
															<!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
															<span class="svg-icon svg-icon-2 position-absolute top-50 translate-middle-y ms-4">
																<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
																	<rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1" transform="rotate(45 17.0365 15.1223)" fill="currentColor" />
																	<path d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z" fill="currentColor" />
																</svg>
															</span>
															<!--end::Svg Icon-->
															<input type="text" data-kt-table-widget-4="search" class="form-control w-150px fs-7 ps-12" placeholder="Search" />
														</div>
														<!--end::Search-->
													</div>
													<!--begin::Filters-->
												</div>
												<!--end::Actions-->
											</div>
											<!--end::Card header-->
											<!--begin::Card body-->
											<div class="card-body pt-2">
												<!--begin::Table-->
												<table class="table align-middle table-row-dashed fs-6 gy-3" id="kt_table_widget_4_table">
													<!--begin::Table head-->
													<thead>
														<!--begin::Table row-->
														<tr class="text-start text-gray-400 fw-bolder fs-7 text-uppercase gs-0">
															<th class="min-w-100px">Product Name</th>
															<th class="text-start min-w-100px">Variation</th>
															<th class="text-end min-w-100px">Unit Price</th>
															<th class="text-end min-w-100px">Sale Price</th>
															<th class="text-end min-w-125px">Quantity</th>
															<th class="text-end min-w-50px">Status</th>
														</tr>
														<!--end::Table row-->
													</thead>
													<!--end::Table head-->
													<!--begin::Table body-->
													<tbody class="fw-bolder text-gray-600">
														@foreach($stock as $equipment)
															@foreach ($equipment->completeStock as $stockReport)
															<tr>
																<td>
																	<a href="/admin/product/{{$equipment->id}}" class="text-gray-800 text-hover-primary">{{$equipment->name}}</a>
																</td>
																<td class="text-start">
																	@foreach ($stockReport->productGroups as $variation)
																		<b>{{$variation->attribute->name.': '.$variation->attributeOption->name}}</b><br>
																	@endforeach	
																</td>
																<td class="text-end">${{$stockReport->unit_price}}</td>
																<td class="text-end">
																	<span class="text-gray-800 fw-boldest">${{$stockReport->sale_price}}</span>
																</td>
																<td class="text-end">
																	{{$stockReport->qty - $stockReport->qty_sold}}
																</td>
																<td class="text-end">
																	@if( ($stockReport->qty - $stockReport->qty_sold) > 15 )
																		<span class="badge py-3 px-4 fs-7 badge-light-success">In Stock</span>
																	@elseif( ($stockReport->qty - $stockReport->qty_sold) == 0 )
																		<span class="badge py-3 px-4 fs-7 badge-light-danger">Out of Stock</span>
																	@elseif( ($stockReport->qty - $stockReport->qty_sold) <= 15 )
																		<span class="badge py-3 px-4 fs-7 badge-light-warning">Low Stock</span>	
																	@endif
																</td>
															</tr>
															@endforeach
														@endforeach  
													</tbody>
													<!--end::Table body-->
												</table>
												<!--end::Table-->
											</div>
											<!--end::Card body-->
										</div>
										<!--end::Table Widget 4-->
									</div>
									<!--end::Col-->
								</div>
								<!--end::Row-->
							</div>
							<!--end::Container-->
						</div>
						<!--end::Post-->
					</div>
					<!--end::Content-->
					<!--begin::Footer-->
					@include('partials.footer')
					<!--end::Footer-->
				</div>
				<!--end::Wrapper-->
			</div>
			<!--end::Page-->
		</div>
		<!--end::Root-->
		
		<!--begin::Javascript-->
		@include('global.footer-links')
		<!--end::Javascript-->
	</body>
	<!--end::Body-->
</html>