<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $rec = [
            [
                'username' => 'travis',
                'email' => 'travis@gologonow.com',
                'password' => Hash::make('123456'),
                'role' => 'admin'
            ],
            [
                'username' => 'kurt',
                'email' => 'kurt@gologonow.com',
                'password' => Hash::make('123456'),
                'role' => 'manager'
            ],
        ];
  
        foreach ($rec as $key => $value) {
            
            $user = User::create(['username' => $value['username'],'email' => $value['email'],'password' => $value['password']]);
            $role = Role::create(['name' => $value['role']]);
            $permissions = Permission::pluck('id','id')->all();
            $role->syncPermissions($permissions);
            $user->assignRole([$role->id]);

        }
    }
}
