<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class projectCost extends Model
{
    use HasFactory;
    protected $fillable = [
        'project_id',
        'amount_charged',
        'amount_type',
        'pay_through',
        'comments',
        'date',
        'user_id'
    ];

    public function project()
    {
        return $this->belongsTo(project::class, 'project_id', 'id');
    }

    public function agent()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
