<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class project extends Model
{
    use HasFactory;
    protected $fillable = [
        'title',
        'description',
        'budget',
        'currency',
        'client_id',
        'comment',
        'status_id'
    ];

    public function client()
    {
        return $this->belongsTo(client::class, 'client_id', 'id');
    }

    public function payments()
    {
        return $this->hasMany(projectCost::class, 'project_id', 'id');
    }
}