<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class client extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'business_name',
        'email',
        'cell_phone',
        'cell_phone_alt',
        'location',
        'on_board_date',
        'account_id',
        'lead_status',
        'created_by'
    ];

    public function status()
    {
        return $this->belongsTo(leadStatus::class, 'lead_status', 'id');
    }

    public function leadStatus()
    {
        return $this->hasMany(leadMonitor::class, 'lead_id', 'id')->orderBy('id', 'DESC');
    }

    public function agent()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }

    public function project()
    {
        return $this->hasOne(project::class, 'client_id', 'id'); //HasOne
    }

    public function projects()
    {
        return $this->hasMany(project::class, 'client_id', 'id'); //HasMany
    }
}