<?php

namespace App\Http\Controllers;

use App\Models\account;
use App\Models\client;
use App\Models\department;
use App\Models\project;
use App\Models\projectCost;
use App\Models\User;
use Illuminate\Http\Request;

class LayoutController extends Controller
{
    public function login()
    {
        return view('index');
    }

    public function register()
    {
        $deparment = department::orderBy('id', 'DESC')->get();
        $data['department'] = $deparment;
        return view('create-account', $data);
    }

    public function department()
    {
        $deparment = department::orderBy('id', 'DESC')->get();
        $data['department'] = $deparment;
        return view('admin.department.index', $data);
    }

    public function account()
    {
        $account = account::orderBy('id', 'DESC')->get();
        $data['account'] = $account;
        return view('admin.account.index', $data);
    }

    public function lead()
    {
        $client = client::with('agent')
        ->with(['leadStatus.status', 'leadStatus.createdBy'])
        ->with('status')
        ->orderBy('id', 'DESC')
        ->get();
        
        $agents = User::with('prsonalInformation')
        ->orderBy('id')
        ->get();
        
        $account = account::orderBy('id', 'DESC')
        ->get();
        
        $data['account'] = $account;
        $data['client'] = $client;
        $data['agents'] = $agents;
        
        return view('admin.lead.index', $data);
    }

    public function leadShow($id)
    {
        $client = client::with('agent')
        ->with(['leadStatus.status', 'leadStatus.createdBy'])
        ->with('status')
        ->where('id', $id)
        ->first();
        $data['lead'] = $client;
        // return $data;
        return view('admin.lead.show', $data);
    }

    public function project()
    {
        $project = project::with('client')->with('payments')->where('status_id', 1)->orderBy('id', 'DESC')->get();
        $account = account::orderBy('id', 'DESC')->get();
        $client = client::orderBy('id', 'DESC')->get();
        $agent = User::orderBy('id', 'DESC')->get();

        $i = 0;

        foreach ($project as $value) {
            foreach ($value->payments as $payment) {
                $value['total_earnings'] += $payment->amount_charged;
                $percentage = ($value['total_earnings']*100) / $value->budget;
                $value['earning_percentage'] = floor($percentage);
            }
        }
        
        $data['project'] = $project;
        $data['account'] = $account;
        $data['client'] = $client;
        $data['agent'] = $agent;
        // return $data;
        return view('admin.project.index', $data);
    }

    public function projectDelivered($id)
    {
        $project = project::find($id);

        if($project)
        {
            $project->status_id = 2;
            $project->save();
            return back()->with(['message' => 'Marked as complete.']);
        }
    }

    public function completeProject()
    {
        $project = project::with('client')->with('payments')->where('status_id', 2)->orderBy('id', 'DESC')->get();
        $account = account::orderBy('id', 'DESC')->get();
        $client = client::orderBy('id', 'DESC')->get();

        $i = 0;

        foreach ($project as $value) {
            foreach ($value->payments as $payment) {
                $value['total_earnings'] += $payment->amount_charged;
                $percentage = ($value['total_earnings']*100) / $value->budget;
                $value['earning_percentage'] = floor($percentage);
            }
        }
        
        $data['project'] = $project;
        $data['account'] = $account;
        $data['client'] = $client;
        // return $data;
        return view('admin.project.projects-complete', $data);
    }

    public function projectRevert($id)
    {
        $project = project::find($id);

        if($project)
        {
            $project->status_id = 1;
            $project->save();
            return back()->with(['error' => 'Project revert successfully.']);
        }
    }
    
    public function projectCosting()
    {
        $projectCosting = projectCost::with('project.client')->with('agent')->orderBy('date', 'DESC')->get();
        $project = project::orderBy('id', 'DESC')->get();
        $agent = User::where('status', 1)->orderBy('id', 'DESC')->get();
        
        $data['projectCosting'] = $projectCosting;
        $data['project'] = $project;
        $data['agent'] = $agent;
        
        // return $data;
        return view('admin.project-costing.index', $data);
    }

    public function agent()
    {
        $month = 1;
        $agents = User::with('prsonalInformation.department')
        // ->with('targets')
        // ->whereHas('targets', function($q) use($month)
        // {
        //     $q->where('month', '2023-01-01');
        // })
        ->get();
        
        foreach ($agents as $value) {
            
            $value['role'] = $value->getRoleNames();

        }

        $data['agents'] = $agents;
        // return $data;
        return view('admin.agent.index', $data);
    }
}